/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.handler.ipfilter;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandler;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandlerContext;
import shaded.com.scylladb.cdc.driver3.handler.ipfilter.AbstractRemoteAddressFilter;
import shaded.com.scylladb.cdc.driver3.handler.ipfilter.IpFilterRule;
import shaded.com.scylladb.cdc.driver3.handler.ipfilter.IpFilterRuleType;
import shaded.com.scylladb.cdc.driver3.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final List<IpFilterRule> rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this(true, rules);
    }

    public RuleBasedIpFilter(boolean acceptIfNotFound, IpFilterRule ... rules) {
        ObjectUtil.checkNotNull(rules, "rules");
        this.acceptIfNotFound = acceptIfNotFound;
        this.rules = new ArrayList<IpFilterRule>(rules.length);
        for (IpFilterRule rule : rules) {
            if (rule == null) continue;
            this.rules.add(rule);
        }
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return this.acceptIfNotFound;
    }
}

