/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.resolver.InetNameResolver;
import shaded.com.scylladb.cdc.driver3.util.concurrent.EventExecutor;
import shaded.com.scylladb.cdc.driver3.util.concurrent.Promise;
import shaded.com.scylladb.cdc.driver3.util.internal.SocketUtils;

public class DefaultNameResolver
extends InetNameResolver {
    public DefaultNameResolver(EventExecutor executor) {
        super(executor);
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        try {
            promise.setSuccess(SocketUtils.addressByName(inetHost));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        try {
            promise.setSuccess(Arrays.asList(SocketUtils.allAddressesByName(inetHost)));
        }
        catch (UnknownHostException e) {
            promise.setFailure(e);
        }
    }
}

