/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.resolver.InetNameResolver;
import shaded.com.scylladb.cdc.driver3.resolver.NameResolver;
import shaded.com.scylladb.cdc.driver3.util.concurrent.EventExecutor;
import shaded.com.scylladb.cdc.driver3.util.concurrent.Future;
import shaded.com.scylladb.cdc.driver3.util.concurrent.FutureListener;
import shaded.com.scylladb.cdc.driver3.util.concurrent.GenericFutureListener;
import shaded.com.scylladb.cdc.driver3.util.concurrent.Promise;
import shaded.com.scylladb.cdc.driver3.util.internal.PlatformDependent;

public class RoundRobinInetAddressResolver
extends InetNameResolver {
    private final NameResolver<InetAddress> nameResolver;

    public RoundRobinInetAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super(executor);
        this.nameResolver = nameResolver;
    }

    @Override
    protected void doResolve(final String inetHost, final Promise<InetAddress> promise) throws Exception {
        this.nameResolver.resolveAll(inetHost).addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                if (future.isSuccess()) {
                    List<InetAddress> inetAddresses = future.getNow();
                    int numAddresses = inetAddresses.size();
                    if (numAddresses > 0) {
                        promise.setSuccess(inetAddresses.get(RoundRobinInetAddressResolver.randomIndex(numAddresses)));
                    } else {
                        promise.setFailure(new UnknownHostException(inetHost));
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    @Override
    protected void doResolveAll(String inetHost, final Promise<List<InetAddress>> promise) throws Exception {
        this.nameResolver.resolveAll(inetHost).addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                if (future.isSuccess()) {
                    List<InetAddress> inetAddresses = future.getNow();
                    if (!inetAddresses.isEmpty()) {
                        ArrayList<InetAddress> result = new ArrayList<InetAddress>(inetAddresses);
                        Collections.rotate(result, RoundRobinInetAddressResolver.randomIndex(inetAddresses.size()));
                        promise.setSuccess(result);
                    } else {
                        promise.setSuccess(inetAddresses);
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    private static int randomIndex(int numAddresses) {
        return numAddresses == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(numAddresses);
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

