/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.util.concurrent;

import shaded.com.scylladb.cdc.driver3.util.concurrent.FastThreadLocal;
import shaded.com.scylladb.cdc.driver3.util.internal.ObjectUtil;

final class FastThreadLocalRunnable
implements Runnable {
    private final Runnable runnable;

    private FastThreadLocalRunnable(Runnable runnable) {
        this.runnable = ObjectUtil.checkNotNull(runnable, "runnable");
    }

    @Override
    public void run() {
        try {
            this.runnable.run();
        }
        finally {
            FastThreadLocal.removeAll();
        }
    }

    static Runnable wrap(Runnable runnable) {
        return runnable instanceof FastThreadLocalRunnable ? runnable : new FastThreadLocalRunnable(runnable);
    }
}

