/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.scylladb.cdc.debezium.connector.CollectionId;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.debezium.connector.ScyllaOffsetContext;
import com.scylladb.cdc.debezium.connector.ScyllaPartition;
import com.scylladb.cdc.debezium.connector.ScyllaSchema;
import com.scylladb.cdc.debezium.connector.ScyllaSnapshotChangeEventSource;
import com.scylladb.cdc.debezium.connector.ScyllaStreamingChangeEventSource;
import com.scylladb.cdc.debezium.connector.ScyllaTaskContext;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.util.Clock;

public class ScyllaChangeEventSourceFactory
implements ChangeEventSourceFactory<ScyllaPartition, ScyllaOffsetContext> {
    private final ScyllaConnectorConfig configuration;
    private final ScyllaTaskContext taskContext;
    private final ScyllaSchema schema;
    private final EventDispatcher<ScyllaPartition, CollectionId> dispatcher;
    private final Clock clock;

    public ScyllaChangeEventSourceFactory(ScyllaConnectorConfig configuration, ScyllaTaskContext context, ScyllaSchema schema, EventDispatcher<ScyllaPartition, CollectionId> dispatcher, Clock clock) {
        this.configuration = configuration;
        this.taskContext = context;
        this.schema = schema;
        this.dispatcher = dispatcher;
        this.clock = clock;
    }

    public SnapshotChangeEventSource<ScyllaPartition, ScyllaOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<ScyllaPartition> snapshotProgressListener, NotificationService<ScyllaPartition, ScyllaOffsetContext> notificationService) {
        return new ScyllaSnapshotChangeEventSource(this.configuration, snapshotProgressListener, notificationService);
    }

    public StreamingChangeEventSource<ScyllaPartition, ScyllaOffsetContext> getStreamingChangeEventSource() {
        return new ScyllaStreamingChangeEventSource(this.configuration, this.taskContext, this.schema, this.dispatcher, this.clock);
    }
}

