/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.scylladb.cdc.debezium.connector.CollectionId;
import com.scylladb.cdc.debezium.connector.ScyllaChangeRecordEmitter;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.debezium.connector.ScyllaOffsetContext;
import com.scylladb.cdc.debezium.connector.ScyllaPartition;
import com.scylladb.cdc.debezium.connector.ScyllaSchema;
import com.scylladb.cdc.debezium.connector.TaskStateOffsetContext;
import com.scylladb.cdc.model.TaskId;
import com.scylladb.cdc.model.worker.ChangeSchema;
import com.scylladb.cdc.model.worker.RawChange;
import com.scylladb.cdc.model.worker.Task;
import com.scylladb.cdc.model.worker.TaskAndRawChangeConsumer;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScyllaChangesConsumer
implements TaskAndRawChangeConsumer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EventDispatcher<ScyllaPartition, CollectionId> dispatcher;
    private final ScyllaOffsetContext offsetContext;
    private final ScyllaSchema schema;
    private final Clock clock;
    private final boolean usePreimages;
    private final Map<TaskId, RawChange> lastPreImage;
    private final ScyllaConnectorConfig connectorConfig;

    public ScyllaChangesConsumer(EventDispatcher<ScyllaPartition, CollectionId> dispatcher, ScyllaOffsetContext offsetContext, ScyllaSchema schema, Clock clock, ScyllaConnectorConfig connectorConfig) {
        this.dispatcher = dispatcher;
        this.offsetContext = offsetContext;
        this.schema = schema;
        this.clock = clock;
        this.connectorConfig = connectorConfig;
        this.usePreimages = connectorConfig.getPreimagesEnabled();
        this.lastPreImage = this.usePreimages ? new HashMap<TaskId, RawChange>() : null;
    }

    public CompletableFuture<Void> consume(Task task, RawChange change) {
        try {
            boolean hasClusteringColumn;
            this.logger.trace("Consuming RawChange of type {}", (Object)change.getOperationType());
            if (this.usePreimages && change.getOperationType() == RawChange.OperationType.PRE_IMAGE) {
                this.lastPreImage.put(task.id, change);
                return CompletableFuture.completedFuture(null);
            }
            Task updatedTask = task.updateState(change.getId());
            TaskStateOffsetContext taskStateOffsetContext = this.offsetContext.taskStateOffsetContext(task.id);
            taskStateOffsetContext.dataChangeEvent(updatedTask.state);
            RawChange.OperationType operationType = change.getOperationType();
            ChangeSchema changeSchema = change.getSchema();
            if (operationType == RawChange.OperationType.PARTITION_DELETE ? (hasClusteringColumn = changeSchema.getNonCdcColumnDefinitions().stream().anyMatch(column -> column.getBaseTableColumnType() == ChangeSchema.ColumnType.CLUSTERING_KEY)) : operationType != RawChange.OperationType.ROW_INSERT && operationType != RawChange.OperationType.ROW_UPDATE && operationType != RawChange.OperationType.ROW_DELETE) {
                return CompletableFuture.completedFuture(null);
            }
            if (this.usePreimages && this.lastPreImage.containsKey(task.id)) {
                this.dispatcher.dispatchDataChangeEvent((Partition)new ScyllaPartition(this.offsetContext, taskStateOffsetContext.sourceInfo), (DataCollectionId)new CollectionId(task.id.getTable()), (ChangeRecordEmitter)new ScyllaChangeRecordEmitter(new ScyllaPartition(this.offsetContext, taskStateOffsetContext.sourceInfo), this.lastPreImage.get(task.id), change, taskStateOffsetContext, this.schema, this.clock, this.connectorConfig));
                this.lastPreImage.remove(task.id);
            } else {
                this.dispatcher.dispatchDataChangeEvent((Partition)new ScyllaPartition(this.offsetContext, taskStateOffsetContext.sourceInfo), (DataCollectionId)new CollectionId(task.id.getTable()), (ChangeRecordEmitter)new ScyllaChangeRecordEmitter(new ScyllaPartition(this.offsetContext, taskStateOffsetContext.sourceInfo), null, change, taskStateOffsetContext, this.schema, this.clock, this.connectorConfig));
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Exception while dispatching change: {}", (Object)change.getId().toString());
            this.logger.error("Exception details: {}", (Object)e.getMessage());
        }
        return CompletableFuture.completedFuture(null);
    }
}

