/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.scylladb.cdc.cql.MasterCQL;
import com.scylladb.cdc.cql.driver3.Driver3MasterCQL;
import com.scylladb.cdc.cql.driver3.Driver3Session;
import com.scylladb.cdc.debezium.connector.Module;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorTask;
import com.scylladb.cdc.debezium.connector.ScyllaMasterTransport;
import com.scylladb.cdc.debezium.connector.ScyllaSessionBuilder;
import com.scylladb.cdc.debezium.connector.TaskConfigBuilder;
import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.TableName;
import com.scylladb.cdc.model.TaskId;
import com.scylladb.cdc.model.master.Master;
import com.scylladb.cdc.model.master.MasterConfiguration;
import com.scylladb.cdc.transport.MasterTransport;
import io.debezium.config.Configuration;
import io.debezium.util.Threads;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScyllaConnector
extends SourceConnector {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Configuration config;
    private ScyllaMasterTransport masterTransport;
    private ExecutorService masterExecutor;
    private Driver3Session masterSession;

    public void start(Map<String, String> props) {
        Configuration config = Configuration.from(props);
        ScyllaConnectorConfig connectorConfig = new ScyllaConnectorConfig(config);
        this.config = config;
        this.startMaster(connectorConfig);
    }

    private Master buildMaster(ScyllaConnectorConfig connectorConfig) {
        this.masterSession = new ScyllaSessionBuilder(connectorConfig).build();
        Driver3MasterCQL cql = new Driver3MasterCQL(this.masterSession);
        this.masterTransport = new ScyllaMasterTransport(this.context(), connectorConfig);
        Set<TableName> tableNames = connectorConfig.getTableNames();
        MasterConfiguration masterConfiguration = MasterConfiguration.builder().withTransport((MasterTransport)this.masterTransport).withCQL((MasterCQL)cql).addTables(tableNames).build();
        return new Master(masterConfiguration);
    }

    private void startMaster(ScyllaConnectorConfig connectorConfig) {
        Master master = this.buildMaster(connectorConfig);
        this.masterExecutor = Threads.newSingleThreadExecutor(ScyllaConnector.class, (String)connectorConfig.getLogicalName(), (String)"scylla-cdc-java-master-executor");
        this.masterExecutor.execute(() -> {
            master.run();
            this.logger.info("scylla-cdc-java library master gracefully finished.");
        });
    }

    public Class<? extends Task> taskClass() {
        return ScyllaConnectorTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        Map<TaskId, SortedSet<StreamId>> tasks = this.masterTransport.getWorkerConfigurations();
        List<String> workerConfigs = new TaskConfigBuilder(tasks).buildTaskConfigs(maxTasks);
        return workerConfigs.stream().map(c -> ((Configuration.Builder)((Configuration.Builder)this.config.edit().with(ScyllaConnectorConfig.WORKER_CONFIG, c)).withDefault(ScyllaConnectorConfig.CUSTOM_HEARTBEAT_INTERVAL, ScyllaConnectorConfig.CUSTOM_HEARTBEAT_INTERVAL.defaultValue())).build().asMap()).collect(Collectors.toList());
    }

    public void stop() {
        Thread.interrupted();
        if (this.masterExecutor != null) {
            this.masterExecutor.shutdownNow();
        }
        if (this.masterSession != null) {
            this.masterSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map results = config.validate(ScyllaConnectorConfig.EXPOSED_FIELDS);
        ConfigValue clusterIpAddressesConfig = (ConfigValue)results.get(ScyllaConnectorConfig.CLUSTER_IP_ADDRESSES.name());
        ConfigValue userConfig = (ConfigValue)results.get(ScyllaConnectorConfig.USER.name());
        ConfigValue passwordConfig = (ConfigValue)results.get(ScyllaConnectorConfig.PASSWORD.name());
        boolean noErrors = results.values().stream().allMatch(c -> c.errorMessages().isEmpty());
        if (noErrors) {
            ScyllaConnectorConfig connectorConfig = new ScyllaConnectorConfig(config);
            if (connectorConfig.getUser() == null && connectorConfig.getPassword() != null) {
                userConfig.addErrorMessage("Username is not set while password was set.");
            } else if (connectorConfig.getUser() != null && connectorConfig.getPassword() == null) {
                passwordConfig.addErrorMessage("Password is not set while username was set.");
            }
            try {
                Master master = this.buildMaster(connectorConfig);
                Optional validation = master.validate();
                validation.ifPresent(error -> clusterIpAddressesConfig.addErrorMessage(error.getMessage()));
            }
            catch (Exception ex) {
                clusterIpAddressesConfig.addErrorMessage("Unable to connect to Scylla cluster: " + ex.getMessage());
            }
            finally {
                this.stop();
            }
        }
        return new Config(new ArrayList(results.values()));
    }

    public String version() {
        return Module.version();
    }

    public ConfigDef config() {
        return ScyllaConnectorConfig.configDef();
    }

    static {
        System.setProperty("flogger.backend_factory", "com.google.common.flogger.backend.log4j.Log4jBackendFactory#getInstance");
    }
}

