/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.core.utils.UUIDs;
import com.scylladb.cdc.debezium.connector.CollectionId;
import com.scylladb.cdc.debezium.connector.ConfigSerializerUtil;
import com.scylladb.cdc.debezium.connector.Module;
import com.scylladb.cdc.debezium.connector.ScyllaChangeEventSourceFactory;
import com.scylladb.cdc.debezium.connector.ScyllaConnector;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.debezium.connector.ScyllaErrorHandler;
import com.scylladb.cdc.debezium.connector.ScyllaEventMetadataProvider;
import com.scylladb.cdc.debezium.connector.ScyllaInconsistentSchemaHandler;
import com.scylladb.cdc.debezium.connector.ScyllaOffsetContext;
import com.scylladb.cdc.debezium.connector.ScyllaPartition;
import com.scylladb.cdc.debezium.connector.ScyllaSchema;
import com.scylladb.cdc.debezium.connector.ScyllaTaskContext;
import com.scylladb.cdc.debezium.connector.SourceInfo;
import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.TaskId;
import com.scylladb.cdc.model.Timestamp;
import com.scylladb.cdc.model.worker.ChangeId;
import com.scylladb.cdc.model.worker.ChangeTime;
import com.scylladb.cdc.model.worker.TaskState;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.document.DocumentReader;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScyllaConnectorTask
extends BaseSourceTask<ScyllaPartition, ScyllaOffsetContext> {
    private static final String CONTEXT_NAME = "scylla-connector-task";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile ScyllaSchema schema;
    private volatile ScyllaTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile ErrorHandler errorHandler;

    protected ChangeEventSourceCoordinator<ScyllaPartition, ScyllaOffsetContext> start(Configuration configuration) {
        ScyllaConnectorConfig connectorConfig = new ScyllaConnectorConfig(configuration);
        DefaultTopicNamingStrategy topicNamingStrategy = DefaultTopicNamingStrategy.create((CommonConnectorConfig)connectorConfig);
        Schema structSchema = connectorConfig.getSourceInfoStructMaker().schema();
        this.schema = new ScyllaSchema(connectorConfig, structSchema);
        List<Pair<TaskId, SortedSet<StreamId>>> tasks = this.getTasks(configuration);
        this.taskContext = new ScyllaTaskContext(configuration, tasks);
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        ScyllaEventMetadataProvider metadataProvider = new ScyllaEventMetadataProvider();
        ScyllaOffsetContext previousOffsets = this.getPreviousOffsets(connectorConfig, tasks);
        SignalProcessor signalProcessor = new SignalProcessor(ScyllaConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), Offsets.of((Partition)new ScyllaPartition(null, null), (OffsetContext)previousOffsets));
        this.errorHandler = new ScyllaErrorHandler(connectorConfig, this.queue, this.errorHandler);
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, (TopicNamingStrategy)topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, id -> true, DataChangeEvent::new, (EventDispatcher.InconsistentSchemaHandler)new ScyllaInconsistentSchemaHandler(), (EventMetadataProvider)metadataProvider, connectorConfig.createHeartbeat((TopicNamingStrategy)topicNamingStrategy, connectorConfig.schemaNameAdjuster(), null, null), SchemaNameAdjuster.create(), signalProcessor);
        Clock clock = Clock.system();
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(Offsets.of((Partition)new ScyllaPartition(null, null), (OffsetContext)previousOffsets), this.errorHandler, ScyllaConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new ScyllaChangeEventSourceFactory(connectorConfig, this.taskContext, this.schema, (EventDispatcher<ScyllaPartition, CollectionId>)dispatcher, clock), (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    private List<Pair<TaskId, SortedSet<StreamId>>> getTasks(Configuration configuration) {
        String serializedTasks = configuration.getString(ScyllaConnectorConfig.WORKER_CONFIG);
        return Arrays.stream(serializedTasks.split("\n")).map(ConfigSerializerUtil::deserializeTaskConfig).collect(Collectors.toList());
    }

    private ScyllaOffsetContext getPreviousOffsets(ScyllaConnectorConfig connectorConfig, List<Pair<TaskId, SortedSet<StreamId>>> tasks) {
        HashMap<TaskId, SourceInfo> sourceInfos = new HashMap<TaskId, SourceInfo>();
        tasks.forEach(t -> {
            TaskId taskId = (TaskId)t.getLeft();
            SourceInfo sourceInfo = new SourceInfo(connectorConfig, taskId);
            sourceInfos.put(taskId, sourceInfo);
        });
        List partitions = sourceInfos.values().stream().map(SourceInfo::partition).collect(Collectors.toList());
        Map offsetMap = this.context.offsetStorageReader().offsets(partitions);
        sourceInfos.values().forEach(sourceInfo -> {
            Map<String, String> partition = sourceInfo.partition();
            Map offset = (Map)offsetMap.get(partition);
            if (offset != null) {
                Timestamp windowStart = new Timestamp(new Date(UUIDs.unixTimestamp((UUID)UUID.fromString((String)offset.get("window_start")))));
                Timestamp windowEnd = new Timestamp(new Date(UUIDs.unixTimestamp((UUID)UUID.fromString((String)offset.get("window_end")))));
                Optional<Object> changeId = Optional.empty();
                if (offset.containsKey("change_id_stream_id") && offset.containsKey("change_id_time")) {
                    StreamId streamId = new StreamId(Bytes.fromHexString((String)((String)offset.get("change_id_stream_id"))));
                    UUID time = UUID.fromString((String)offset.get("change_id_time"));
                    changeId = Optional.of(new ChangeId(streamId, new ChangeTime(time)));
                }
                TaskState taskState = new TaskState(windowStart, windowEnd, changeId);
                sourceInfo.setTaskState(taskState);
            }
        });
        return new ScyllaOffsetContext(sourceInfos, new TransactionContext());
    }

    protected List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    protected void doStop() {
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return ScyllaConnectorConfig.ALL_FIELDS;
    }

    public String version() {
        return Module.version();
    }

    static {
        System.setProperty("flogger.backend_factory", "com.google.common.flogger.backend.log4j.Log4jBackendFactory#getInstance");
    }
}

