/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.datastax.driver.core.utils.UUIDs;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.debezium.connector.SourceInfo;
import com.scylladb.cdc.model.GenerationId;
import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.TaskId;
import com.scylladb.cdc.model.Timestamp;
import com.scylladb.cdc.transport.MasterTransport;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceConnectorContext;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScyllaMasterTransport
implements MasterTransport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SourceConnectorContext context;
    private final ScyllaConnectorConfig connectorConfig;
    private volatile Map<TaskId, SortedSet<StreamId>> currentWorkerConfigurations;

    public ScyllaMasterTransport(SourceConnectorContext context, ScyllaConnectorConfig connectorConfig) {
        this.context = context;
        this.connectorConfig = connectorConfig;
    }

    public Optional<GenerationId> getCurrentGenerationId() {
        return Optional.empty();
    }

    public boolean areTasksFullyConsumedUntil(Set<TaskId> tasks, Timestamp until) {
        OffsetStorageReader reader = this.context.offsetStorageReader();
        List partitions = tasks.stream().map(taskId -> new SourceInfo(this.connectorConfig, (TaskId)taskId).partition()).collect(Collectors.toList());
        Collection offsets = reader.offsets(partitions).values();
        return offsets.stream().allMatch(o -> this.isOffsetFullyConsumedUntil((Map<String, Object>)o, until));
    }

    private boolean isOffsetFullyConsumedUntil(Map<String, Object> offset, Timestamp until) {
        if (offset == null) {
            return false;
        }
        UUID offsetUUID = UUID.fromString((String)offset.get("window_start"));
        Date offsetDate = new Date(UUIDs.unixTimestamp((UUID)offsetUUID));
        return offsetDate.after(until.toDate());
    }

    public void configureWorkers(Map<TaskId, SortedSet<StreamId>> workerConfigurations) {
        this.currentWorkerConfigurations = workerConfigurations;
        this.context.requestTaskReconfiguration();
    }

    public Map<TaskId, SortedSet<StreamId>> getWorkerConfigurations() {
        return this.currentWorkerConfigurations;
    }
}

