/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.google.common.collect.ImmutableMap;
import com.scylladb.cdc.debezium.connector.ScyllaPartition;
import com.scylladb.cdc.debezium.connector.SourceInfo;
import com.scylladb.cdc.debezium.connector.TaskStateOffsetContext;
import com.scylladb.cdc.model.TaskId;
import io.debezium.connector.SnapshotRecord;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.spi.schema.DataCollectionId;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class ScyllaOffsetContext
implements OffsetContext {
    private final Map<TaskId, SourceInfo> sourceInfos;
    private final TransactionContext transactionContext;

    public ScyllaOffsetContext(Map<TaskId, SourceInfo> sourceInfos, TransactionContext transactionContext) {
        this.sourceInfos = sourceInfos;
        this.transactionContext = transactionContext;
    }

    public TaskStateOffsetContext taskStateOffsetContext(TaskId taskId) {
        return new TaskStateOffsetContext(this, this.sourceInfos.get(taskId));
    }

    public Offsets<ScyllaPartition, TaskStateOffsetContext> toDebeziumOffsets() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.sourceInfos.values().forEach(sourceInfo -> builder.put((Object)new ScyllaPartition(this, (SourceInfo)((Object)sourceInfo)), (Object)new TaskStateOffsetContext(this, (SourceInfo)((Object)sourceInfo))));
        return Offsets.of((Map)builder.build());
    }

    public Map<String, ?> getOffset() {
        throw new UnsupportedOperationException();
    }

    public Schema getSourceInfoSchema() {
        throw new UnsupportedOperationException();
    }

    public Struct getSourceInfo() {
        throw new UnsupportedOperationException();
    }

    public boolean isSnapshotRunning() {
        throw new UnsupportedOperationException();
    }

    public void markSnapshotRecord(SnapshotRecord snapshotRecord) {
    }

    public void preSnapshotStart() {
    }

    public void preSnapshotCompletion() {
    }

    public void postSnapshotCompletion() {
    }

    public void event(DataCollectionId dataCollectionId, Instant instant) {
        throw new UnsupportedOperationException();
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }
}

