/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.scylladb.cdc.debezium.connector.CollectionId;
import com.scylladb.cdc.debezium.connector.ScyllaCollectionSchema;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.model.worker.ChangeSchema;
import io.debezium.data.Envelope;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaNameAdjuster;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScyllaSchema
implements DatabaseSchema<CollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScyllaSchema.class);
    public static final String CELL_VALUE = "value";
    private final Schema sourceSchema;
    private final ScyllaConnectorConfig configuration;
    private final SchemaNameAdjuster adjuster = SchemaNameAdjuster.create();
    private final Map<CollectionId, ScyllaCollectionSchema> dataCollectionSchemas = new HashMap<CollectionId, ScyllaCollectionSchema>();
    private final Map<CollectionId, ChangeSchema> changeSchemas = new HashMap<CollectionId, ChangeSchema>();

    public ScyllaSchema(ScyllaConnectorConfig configuration, Schema sourceSchema) {
        this.sourceSchema = sourceSchema;
        this.configuration = configuration;
    }

    public void close() {
    }

    public DataCollectionSchema schemaFor(CollectionId collectionId) {
        return this.dataCollectionSchemas.computeIfAbsent(collectionId, this::computeDataCollectionSchema);
    }

    private ScyllaCollectionSchema computeDataCollectionSchema(CollectionId collectionId) {
        ChangeSchema changeSchema = this.changeSchemas.get(collectionId);
        if (changeSchema == null) {
            return null;
        }
        Map<String, Schema> cellSchemas = this.computeCellSchemas(changeSchema, collectionId);
        Schema keySchema = this.computeKeySchema(changeSchema, collectionId);
        Schema beforeSchema = this.computeBeforeSchema(changeSchema, cellSchemas, collectionId);
        Schema afterSchema = this.computeAfterSchema(changeSchema, cellSchemas, collectionId);
        Schema valueSchema = SchemaBuilder.struct().name(this.adjuster.adjust(Envelope.schemaName((String)(this.configuration.getLogicalName() + "." + collectionId.getTableName().keyspace + "." + collectionId.getTableName().name)))).field("source", this.sourceSchema).field("before", beforeSchema).field("after", afterSchema).field("op", Schema.OPTIONAL_STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("transaction", TransactionMonitor.TRANSACTION_BLOCK_SCHEMA).field("ts_us", Schema.OPTIONAL_INT64_SCHEMA).field("ts_ns", Schema.OPTIONAL_INT64_SCHEMA).build();
        Envelope envelope = Envelope.fromSchema((Schema)valueSchema);
        return new ScyllaCollectionSchema(collectionId, keySchema, valueSchema, beforeSchema, afterSchema, cellSchemas, envelope);
    }

    private Map<String, Schema> computeCellSchemas(ChangeSchema changeSchema, CollectionId collectionId) {
        HashMap<String, Schema> cellSchemas = new HashMap<String, Schema>();
        for (ChangeSchema.ColumnDefinition cdef : changeSchema.getNonCdcColumnDefinitions()) {
            if (cdef.getBaseTableColumnType() == ChangeSchema.ColumnType.PARTITION_KEY || cdef.getBaseTableColumnType() == ChangeSchema.ColumnType.CLUSTERING_KEY || !ScyllaSchema.isSupportedColumnSchema(cdef)) continue;
            Schema columnSchema = this.computeColumnSchema(cdef);
            Schema cellSchema = SchemaBuilder.struct().name(this.adjuster.adjust(this.configuration.getLogicalName() + "." + collectionId.getTableName().keyspace + "." + collectionId.getTableName().name + "." + cdef.getColumnName() + ".Cell")).field(CELL_VALUE, columnSchema).optional().build();
            cellSchemas.put(cdef.getColumnName(), cellSchema);
        }
        return cellSchemas;
    }

    private Schema computeKeySchema(ChangeSchema changeSchema, CollectionId collectionId) {
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct().name(this.adjuster.adjust(this.configuration.getLogicalName() + "." + collectionId.getTableName().keyspace + "." + collectionId.getTableName().name + ".Key"));
        for (ChangeSchema.ColumnDefinition cdef : changeSchema.getNonCdcColumnDefinitions()) {
            if (cdef.getBaseTableColumnType() != ChangeSchema.ColumnType.PARTITION_KEY && cdef.getBaseTableColumnType() != ChangeSchema.ColumnType.CLUSTERING_KEY || !ScyllaSchema.isSupportedColumnSchema(cdef)) continue;
            Schema columnSchema = this.computeColumnSchema(cdef);
            keySchemaBuilder = keySchemaBuilder.field(cdef.getColumnName(), columnSchema);
        }
        return keySchemaBuilder.build();
    }

    private Schema computeAfterSchema(ChangeSchema changeSchema, Map<String, Schema> cellSchemas, CollectionId collectionId) {
        SchemaBuilder afterSchemaBuilder = SchemaBuilder.struct().name(this.adjuster.adjust(this.configuration.getLogicalName() + "." + collectionId.getTableName().keyspace + "." + collectionId.getTableName().name + ".After"));
        for (ChangeSchema.ColumnDefinition cdef : changeSchema.getNonCdcColumnDefinitions()) {
            if (!ScyllaSchema.isSupportedColumnSchema(cdef)) continue;
            if (cdef.getBaseTableColumnType() != ChangeSchema.ColumnType.PARTITION_KEY && cdef.getBaseTableColumnType() != ChangeSchema.ColumnType.CLUSTERING_KEY) {
                afterSchemaBuilder = afterSchemaBuilder.field(cdef.getColumnName(), cellSchemas.get(cdef.getColumnName()));
                continue;
            }
            Schema columnSchema = this.computeColumnSchema(cdef);
            afterSchemaBuilder = afterSchemaBuilder.field(cdef.getColumnName(), columnSchema);
        }
        return afterSchemaBuilder.optional().build();
    }

    private Schema computeBeforeSchema(ChangeSchema changeSchema, Map<String, Schema> cellSchemas, CollectionId collectionId) {
        SchemaBuilder beforeSchemaBuilder = SchemaBuilder.struct().name(this.adjuster.adjust(this.configuration.getLogicalName() + "." + collectionId.getTableName().keyspace + "." + collectionId.getTableName().name + ".Before"));
        for (ChangeSchema.ColumnDefinition cdef : changeSchema.getNonCdcColumnDefinitions()) {
            if (!ScyllaSchema.isSupportedColumnSchema(cdef)) continue;
            if (cdef.getBaseTableColumnType() != ChangeSchema.ColumnType.PARTITION_KEY && cdef.getBaseTableColumnType() != ChangeSchema.ColumnType.CLUSTERING_KEY) {
                beforeSchemaBuilder = beforeSchemaBuilder.field(cdef.getColumnName(), cellSchemas.get(cdef.getColumnName()));
                continue;
            }
            Schema columnSchema = this.computeColumnSchema(cdef);
            beforeSchemaBuilder = beforeSchemaBuilder.field(cdef.getColumnName(), columnSchema);
        }
        return beforeSchemaBuilder.optional().build();
    }

    private Schema computeColumnSchema(ChangeSchema.ColumnDefinition cdef) {
        switch (cdef.getCdcLogDataType().getCqlType()) {
            case ASCII: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case BIGINT: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case BLOB: {
                return Schema.OPTIONAL_BYTES_SCHEMA;
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case COUNTER: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case DECIMAL: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case DOUBLE: {
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case FLOAT: {
                return Schema.OPTIONAL_FLOAT32_SCHEMA;
            }
            case INT: {
                return Schema.OPTIONAL_INT32_SCHEMA;
            }
            case TEXT: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case TIMESTAMP: {
                return Timestamp.builder().optional().build();
            }
            case UUID: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case VARCHAR: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case VARINT: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case TIMEUUID: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case INET: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case DATE: {
                return Date.builder().optional().build();
            }
            case TIME: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case SMALLINT: {
                return Schema.OPTIONAL_INT16_SCHEMA;
            }
            case TINYINT: {
                return Schema.OPTIONAL_INT8_SCHEMA;
            }
            case DURATION: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected static boolean isSupportedColumnSchema(ChangeSchema.ColumnDefinition cdef) {
        ChangeSchema.CqlType type = cdef.getCdcLogDataType().getCqlType();
        return type != ChangeSchema.CqlType.LIST && type != ChangeSchema.CqlType.MAP && type != ChangeSchema.CqlType.SET && type != ChangeSchema.CqlType.UDT && type != ChangeSchema.CqlType.TUPLE;
    }

    public ScyllaCollectionSchema updateChangeSchema(CollectionId collectionId, ChangeSchema changeSchema) {
        this.changeSchemas.put(collectionId, changeSchema);
        this.dataCollectionSchemas.put(collectionId, this.computeDataCollectionSchema(collectionId));
        return this.dataCollectionSchemas.get(collectionId);
    }

    public boolean tableInformationComplete() {
        return false;
    }

    public boolean isHistorized() {
        return false;
    }
}

