/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.scylladb.cdc.cql.CQLConfiguration;
import com.scylladb.cdc.cql.SslConfig;
import com.scylladb.cdc.cql.driver3.Driver3Session;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;

public class ScyllaSessionBuilder {
    private final ScyllaConnectorConfig configuration;

    public ScyllaSessionBuilder(ScyllaConnectorConfig configuration) {
        this.configuration = configuration;
    }

    public Driver3Session build() {
        CQLConfiguration.Builder builder = CQLConfiguration.builder();
        builder.withDefaultPort(this.configuration.getDefaultPort());
        builder.addContactPoints(this.configuration.getContactPoints());
        if (this.configuration.getUser() != null && this.configuration.getPassword() != null) {
            builder.withCredentials(this.configuration.getUser(), this.configuration.getPassword());
        }
        builder.withConsistencyLevel(this.configuration.getConsistencyLevel());
        if (this.configuration.getLocalDCName() != null) {
            builder.withLocalDCName(this.configuration.getLocalDCName());
        }
        if (this.configuration.getSslEnabled()) {
            SslConfig.Builder sslBuilder = SslConfig.builder();
            sslBuilder.withSslProviderString(this.configuration.getSslProvider().toString());
            sslBuilder.withTrustStorePath(this.configuration.getTrustStorePath());
            sslBuilder.withTrustStorePassword(this.configuration.getTrustStorePassword());
            sslBuilder.withKeyStorePath(this.configuration.getKeyStorePath());
            sslBuilder.withKeyStorePassword(this.configuration.getKeyStorePassword());
            if (this.configuration.getCipherSuite() != null) {
                this.configuration.getCipherSuite().stream().forEach(arg_0 -> ((SslConfig.Builder)sslBuilder).withCipher(arg_0));
            }
            sslBuilder.withCertPath(this.configuration.getCertPath());
            sslBuilder.withPrivateKeyPath(this.configuration.getPrivateKeyPath());
            builder.withSslConfig(sslBuilder.build());
        }
        builder.withQueryOptionsFetchSize(this.configuration.getQueryOptionsFetchSize());
        builder.withCorePoolLocal(Integer.valueOf(this.configuration.getPoolingCorePoolLocal()));
        builder.withMaxPoolLocal(Integer.valueOf(this.configuration.getPoolingMaxPoolLocal()));
        builder.withPoolingMaxRequestsPerConnectionLocal(Integer.valueOf(this.configuration.getPoolingMaxRequestsPerConnection()));
        builder.withPoolingMaxQueueSize(Integer.valueOf(this.configuration.getPoolingMaxQueueSize()));
        builder.withPoolTimeoutMillis(Integer.valueOf(this.configuration.getPoolingPoolTimeoutMs()));
        return new Driver3Session(builder.build());
    }
}

