/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.scylladb.cdc.cql.WorkerCQL;
import com.scylladb.cdc.cql.driver3.Driver3Session;
import com.scylladb.cdc.cql.driver3.Driver3WorkerCQL;
import com.scylladb.cdc.debezium.connector.CollectionId;
import com.scylladb.cdc.debezium.connector.ScyllaChangesConsumer;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.debezium.connector.ScyllaOffsetContext;
import com.scylladb.cdc.debezium.connector.ScyllaPartition;
import com.scylladb.cdc.debezium.connector.ScyllaSchema;
import com.scylladb.cdc.debezium.connector.ScyllaSessionBuilder;
import com.scylladb.cdc.debezium.connector.ScyllaTaskContext;
import com.scylladb.cdc.debezium.connector.ScyllaWorkerTransport;
import com.scylladb.cdc.model.ExponentialRetryBackoffWithJitter;
import com.scylladb.cdc.model.RetryBackoff;
import com.scylladb.cdc.model.worker.TaskAndRawChangeConsumer;
import com.scylladb.cdc.model.worker.Worker;
import com.scylladb.cdc.model.worker.WorkerConfiguration;
import com.scylladb.cdc.transport.WorkerTransport;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.util.Clock;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class ScyllaStreamingChangeEventSource
implements StreamingChangeEventSource<ScyllaPartition, ScyllaOffsetContext> {
    private final ScyllaConnectorConfig configuration;
    private ScyllaTaskContext taskContext;
    private final ScyllaSchema schema;
    private final EventDispatcher<ScyllaPartition, CollectionId> dispatcher;
    private final Clock clock;
    private final Duration pollInterval;

    public ScyllaStreamingChangeEventSource(ScyllaConnectorConfig configuration, ScyllaTaskContext taskContext, ScyllaSchema schema, EventDispatcher<ScyllaPartition, CollectionId> dispatcher, Clock clock) {
        this.configuration = configuration;
        this.taskContext = taskContext;
        this.schema = schema;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.pollInterval = configuration.getPollInterval();
    }

    public void execute(ChangeEventSource.ChangeEventSourceContext context, ScyllaPartition partition, ScyllaOffsetContext offsetContext) throws InterruptedException {
        Driver3Session session = new ScyllaSessionBuilder(this.configuration).build();
        Driver3WorkerCQL cql = new Driver3WorkerCQL(session);
        ExponentialRetryBackoffWithJitter retryBackoff = this.configuration.createCDCWorkerRetryBackoff();
        ScyllaWorkerTransport workerTransport = new ScyllaWorkerTransport(context, offsetContext, this.dispatcher, this.configuration.getHeartbeatIntervalMs());
        ScyllaChangesConsumer changeConsumer = new ScyllaChangesConsumer(this.dispatcher, offsetContext, this.schema, this.clock, this.configuration);
        WorkerConfiguration workerConfiguration = WorkerConfiguration.builder().withTransport((WorkerTransport)workerTransport).withCQL((WorkerCQL)cql).withConsumer((TaskAndRawChangeConsumer)changeConsumer).withQueryTimeWindowSizeMs(this.configuration.getQueryTimeWindowSizeMs()).withConfidenceWindowSizeMs(this.configuration.getConfidenceWindowSizeMs()).withWorkerRetryBackoff((RetryBackoff)retryBackoff).withMinimalWaitForWindowMs(this.configuration.getMinimalWaitForWindowMs()).build();
        Worker worker = new Worker(workerConfiguration);
        try {
            worker.run(this.taskContext.getTasks().stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

