/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.datastax.driver.core.utils.Bytes;
import com.scylladb.cdc.debezium.connector.ScyllaConnectorConfig;
import com.scylladb.cdc.model.TableName;
import com.scylladb.cdc.model.TaskId;
import com.scylladb.cdc.model.worker.ChangeId;
import com.scylladb.cdc.model.worker.TaskState;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.util.Collect;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Map;

public class SourceInfo
extends BaseSourceInfo {
    public static final String KEYSPACE_NAME = "keyspace_name";
    public static final String TABLE_NAME = "table_name";
    public static final String VNODE_ID = "vnode_id";
    public static final String GENERATION_START = "generation_start";
    public static final String WINDOW_START = "window_start";
    public static final String WINDOW_END = "window_end";
    public static final String CHANGE_ID_STREAM_ID = "change_id_stream_id";
    public static final String CHANGE_ID_TIME = "change_id_time";
    private final TaskId taskId;
    private TaskState taskState;

    protected SourceInfo(ScyllaConnectorConfig connectorConfig, TaskId taskId) {
        super((CommonConnectorConfig)connectorConfig);
        this.taskId = taskId;
    }

    public Map<String, String> partition() {
        return Collect.hashMapOf((Object)KEYSPACE_NAME, (Object)this.taskId.getTable().keyspace, (Object)TABLE_NAME, (Object)this.taskId.getTable().name, (Object)VNODE_ID, (Object)Long.toString(this.taskId.getvNodeId().getIndex()), (Object)GENERATION_START, (Object)Long.toString(this.taskId.getGenerationId().getGenerationStart().toDate().getTime()));
    }

    public Map<String, String> offset() {
        Map result = Collect.hashMapOf((Object)WINDOW_START, (Object)this.taskState.getWindowStart().toString(), (Object)WINDOW_END, (Object)this.taskState.getWindowEnd().toString());
        this.taskState.getLastConsumedChangeId().ifPresent(changeId -> result.putAll(Collect.hashMapOf((Object)CHANGE_ID_STREAM_ID, (Object)Bytes.toHexString((ByteBuffer)changeId.getStreamId().getValue()), (Object)CHANGE_ID_TIME, (Object)changeId.getChangeTime().getUUID().toString())));
        return result;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public void setTaskState(TaskState taskState) {
        this.taskState = taskState;
    }

    public void dataChangeEvent(TaskState taskState) {
        this.setTaskState(taskState);
    }

    public TableName getTableName() {
        return this.taskId.getTable();
    }

    protected Instant timestamp() {
        return ((ChangeId)this.taskState.getLastConsumedChangeId().get()).getChangeTime().getDate().toInstant();
    }

    public long timestampUs() {
        return ((ChangeId)this.taskState.getLastConsumedChangeId().get()).getChangeTime().getTimestamp();
    }

    protected String database() {
        return this.getTableName().keyspace;
    }
}

