/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector;

import com.google.common.collect.Lists;
import com.scylladb.cdc.debezium.connector.ConfigSerializerUtil;
import com.scylladb.cdc.model.StreamId;
import com.scylladb.cdc.model.TaskId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;

public class TaskConfigBuilder {
    private final Map<TaskId, SortedSet<StreamId>> tasks;

    public TaskConfigBuilder(Map<TaskId, SortedSet<StreamId>> tasks) {
        this.tasks = tasks;
    }

    public List<String> buildTaskConfigs(int maxTasks) {
        if (this.tasks == null) {
            return Collections.emptyList();
        }
        List serializedTasks = this.tasks.entrySet().stream().map(t -> {
            TaskId taskId = (TaskId)t.getKey();
            SortedSet streamIds = (SortedSet)t.getValue();
            return ConfigSerializerUtil.serializeTaskConfig(taskId, streamIds);
        }).collect(Collectors.toList());
        int partitionSize = (serializedTasks.size() + maxTasks - 1) / maxTasks;
        List partitionedTasks = Lists.partition(serializedTasks, (int)partitionSize);
        List<String> taskConfigs = partitionedTasks.stream().map(q -> String.join((CharSequence)"\n", q)).collect(Collectors.toList());
        assert (taskConfigs.size() <= maxTasks);
        return taskConfigs;
    }
}

