/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector.transforms;

import io.debezium.transforms.ExtractNewRecordState;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.util.SchemaUtil;

public class ScyllaExtractNewRecordState<R extends ConnectRecord<R>>
extends ExtractNewRecordState<R> {
    private Cache<Schema, Schema> schemaUpdateCache = new SynchronizedCache((Cache)new LRUCache(16));

    public R apply(R record) {
        ConnectRecord ret = super.apply(record);
        if (ret == null || !(ret.value() instanceof Struct)) {
            return (R)ret;
        }
        Struct value = (Struct)ret.value();
        Schema updatedSchema = (Schema)this.schemaUpdateCache.get((Object)value.schema());
        if (updatedSchema == null) {
            updatedSchema = this.makeUpdatedSchema(value.schema());
            this.schemaUpdateCache.put((Object)value.schema(), (Object)updatedSchema);
        }
        Struct updatedValue = new Struct(updatedSchema);
        for (Field field : value.schema().fields()) {
            if (this.isSimplifiableField(field)) {
                Struct fieldValue = (Struct)value.get(field);
                updatedValue.put(field.name(), fieldValue == null ? null : fieldValue.get("value"));
                continue;
            }
            updatedValue.put(field.name(), value.get(field));
        }
        return (R)ret.newRecord(ret.topic(), ret.kafkaPartition(), ret.keySchema(), ret.key(), updatedSchema, (Object)updatedValue, ret.timestamp());
    }

    public void close() {
        super.close();
        this.schemaUpdateCache = null;
    }

    private boolean isSimplifiableField(Field field) {
        if (field.schema().type() != Schema.Type.STRUCT) {
            return false;
        }
        return field.schema().fields().size() == 1 && ((Field)field.schema().fields().get(0)).name() == "value";
    }

    private Schema makeUpdatedSchema(Schema schema) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)schema, (SchemaBuilder)SchemaBuilder.struct());
        for (Field field : schema.fields()) {
            if (this.isSimplifiableField(field)) {
                builder.field(field.name(), field.schema().field("value").schema());
                continue;
            }
            builder.field(field.name(), field.schema());
        }
        return builder.build();
    }
}

