/*
 * Decompiled with CFR 0.152.
 */
package com.scylladb.cdc.debezium.connector.transforms;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SchemaUtil;

public class ScyllaFlattenColumns<R extends ConnectRecord<R>>
implements Transformation<R> {
    private Cache<Schema, Schema> schemaUpdateCache = new SynchronizedCache((Cache)new LRUCache(16));
    private Cache<Schema, Schema> subSchemaUpdateCache = new SynchronizedCache((Cache)new LRUCache(16));

    public R apply(R record) {
        if (record.value() == null || !(record.value() instanceof Struct)) {
            return record;
        }
        Struct value = (Struct)record.value();
        Schema updatedSchema = (Schema)this.schemaUpdateCache.get((Object)value.schema());
        if (updatedSchema == null) {
            updatedSchema = this.makeUpdatedSchema(value.schema());
            this.schemaUpdateCache.put((Object)value.schema(), (Object)updatedSchema);
        }
        Struct updatedValue = new Struct(updatedSchema);
        for (Field field : value.schema().fields()) {
            if (Objects.equals(field.name(), "before") || Objects.equals(field.name(), "after")) {
                Struct fieldValue = (Struct)value.get(field);
                if (fieldValue != null) {
                    Struct updatedFieldValue = new Struct(this.makeUpdatedSubSchema(field.schema()));
                    for (Field subField : field.schema().fields()) {
                        if (this.isSimplifiableField(subField)) {
                            Struct subFieldValue = (Struct)fieldValue.get(subField);
                            updatedFieldValue.put(subField.name(), subFieldValue == null ? null : subFieldValue.get("value"));
                            continue;
                        }
                        updatedFieldValue.put(subField.name(), fieldValue.get(subField));
                    }
                    updatedValue.put(field.name(), (Object)updatedFieldValue);
                    continue;
                }
                updatedValue.put(field.name(), null);
                continue;
            }
            updatedValue.put(field.name(), value.get(field));
        }
        return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, (Object)updatedValue, record.timestamp());
    }

    private boolean isSimplifiableField(Field field) {
        if (field.schema().type() != Schema.Type.STRUCT) {
            return false;
        }
        return field.schema().fields().size() == 1 && Objects.equals(((Field)field.schema().fields().get(0)).name(), "value");
    }

    private Schema makeUpdatedSchema(Schema schema) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)schema, (SchemaBuilder)SchemaBuilder.struct());
        for (Field field : schema.fields()) {
            if (Objects.equals(field.name(), "before") || Objects.equals(field.name(), "after")) {
                builder.field(field.name(), this.makeUpdatedSubSchema(field.schema()));
                continue;
            }
            builder.field(field.name(), field.schema());
        }
        return builder.build();
    }

    private Schema makeUpdatedSubSchema(Schema subSchema) {
        Schema updatedSubSchema = (Schema)this.subSchemaUpdateCache.get((Object)subSchema);
        if (updatedSubSchema != null) {
            return updatedSubSchema;
        }
        SchemaBuilder subBuilder = SchemaUtil.copySchemaBasics((Schema)subSchema, (SchemaBuilder)SchemaBuilder.struct());
        if (subSchema.isOptional()) {
            subBuilder.optional();
        }
        for (Field subField : subSchema.fields()) {
            if (this.isSimplifiableField(subField)) {
                subBuilder.field(subField.name(), subField.schema().field("value").schema());
                continue;
            }
            subBuilder.field(subField.name(), subField.schema());
        }
        updatedSubSchema = subBuilder.build();
        this.subSchemaUpdateCache.put((Object)subSchema, (Object)updatedSubSchema);
        return updatedSubSchema;
    }

    public ConfigDef config() {
        return new ConfigDef();
    }

    public void close() {
        this.schemaUpdateCache = null;
        this.subSchemaUpdateCache = null;
    }

    public void configure(Map<String, ?> map) {
    }
}

