/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.Statement;

class PagingOptimizingLatencyTracker
implements LatencyTracker {
    PagingOptimizingLatencyTracker() {
    }

    @Override
    public void update(Host host, Statement statement, Exception exception, long newLatencyNanos) {
        if (!(statement instanceof BoundStatement)) {
            return;
        }
        if (exception == null) {
            statement.setLastHost(host);
        } else {
            Host lastHost = statement.getLastHost();
            if (lastHost != null && lastHost.equals(host)) {
                statement.setLastHost(null);
            }
        }
    }

    @Override
    public void onRegister(Cluster cluster) {
    }

    @Override
    public void onUnregister(Cluster cluster) {
    }
}

