/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.EndPointFactory;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SniEndPoint;
import java.net.InetSocketAddress;
import java.util.UUID;

class ScyllaCloudSniEndPointFactory
implements EndPointFactory {
    private final String nodeDomain;
    private final InetSocketAddress proxy;

    public ScyllaCloudSniEndPointFactory(InetSocketAddress proxy, String nodeDomain) {
        this.proxy = proxy;
        this.nodeDomain = nodeDomain;
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public EndPoint create(Row row) {
        UUID host_id = row.getUUID("host_id");
        String sni = host_id.toString() + "." + this.nodeDomain;
        return new SniEndPoint(this.proxy, sni);
    }
}

