/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RackAwareRoundRobinPolicy
implements LoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RackAwareRoundRobinPolicy.class);
    private static final String UNSET = "";
    private final ConcurrentMap<String, CopyOnWriteArrayList<Host>> perDcLiveHosts = new ConcurrentHashMap<String, CopyOnWriteArrayList<Host>>();
    private final CopyOnWriteArrayList<Host> liveHostsLocalRackLocalDC = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Host> liveHostsRemoteRacksLocalDC = new CopyOnWriteArrayList();
    private final AtomicInteger index = new AtomicInteger();
    @VisibleForTesting
    volatile String localDc;
    @VisibleForTesting
    volatile String localRack;
    private final int usedHostsPerRemoteDc;
    private final boolean dontHopForLocalCL;
    private volatile Configuration configuration;

    public static Builder builder() {
        return new Builder();
    }

    public RackAwareRoundRobinPolicy(String localDc, String localRack, int usedHostsPerRemoteDc, boolean allowRemoteDCsForLocalConsistencyLevel, boolean allowEmptyLocalDc, boolean allowEmptyLocalRack) {
        if (!allowEmptyLocalDc && Strings.isNullOrEmpty((String)localDc)) {
            throw new IllegalArgumentException("Null or empty data center specified for Rack-aware policy");
        }
        if (!allowEmptyLocalRack && Strings.isNullOrEmpty((String)localRack)) {
            throw new IllegalArgumentException("Null or empty rack specified for Rack-aware policy");
        }
        this.localDc = localDc == null ? UNSET : localDc;
        this.localRack = localRack == null ? UNSET : localRack;
        this.usedHostsPerRemoteDc = usedHostsPerRemoteDc;
        this.dontHopForLocalCL = !allowRemoteDCsForLocalConsistencyLevel;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        String nonLocalHosts;
        if (this.localDc != UNSET) {
            logger.info("Using provided data-center name '{}' for RackAwareRoundRobinPolicy", (Object)this.localDc);
        }
        if (this.localRack != UNSET) {
            logger.info("Using provided rack name '{}' for RackAwareRoundRobinPolicy", (Object)this.localRack);
        }
        this.configuration = cluster.getConfiguration();
        ArrayList<String> notInLocalDC = new ArrayList<String>();
        ArrayList<String> notInLocalRack = new ArrayList<String>();
        for (Host host : hosts) {
            String dc = this.dc(host);
            String rack = this.rack(host);
            if (this.localDc == UNSET && dc != UNSET) {
                logger.info("Using data-center name '{}' for RackAwareRoundRobinPolicy (if this is incorrect, please provide the correct datacenter name with RackAwareRoundRobinPolicy constructor)", (Object)dc);
                this.localDc = dc;
            } else if (!dc.equals(this.localDc)) {
                notInLocalDC.add(String.format("%s (%s)", host.toString(), dc));
            }
            if (this.localRack == UNSET && rack != UNSET) {
                logger.info("Using rack name '{}' for RackAwareRoundRobinPolicy (if this is incorrect, please provide the correct rack name with RackAwareRoundRobinPolicy constructor)", (Object)rack);
                this.localRack = rack;
            } else if (!rack.equals(this.localRack)) {
                notInLocalRack.add(String.format("%s (dc=%s, rack=%s)", host.toString(), dc, rack));
            }
            CopyOnWriteArrayList prev = (CopyOnWriteArrayList)this.perDcLiveHosts.get(dc);
            if (prev == null) {
                this.perDcLiveHosts.put(dc, new CopyOnWriteArrayList<Host>(Collections.singletonList(host)));
            } else {
                prev.addIfAbsent(host);
            }
            if (!dc.equals(this.localDc)) continue;
            if (rack.equals(this.localRack)) {
                this.liveHostsLocalRackLocalDC.add(host);
                continue;
            }
            this.liveHostsRemoteRacksLocalDC.add(host);
        }
        if (notInLocalDC.size() > 0) {
            nonLocalHosts = Joiner.on((String)",").join(notInLocalDC);
            logger.warn("Some contact points don't match local data center. Local DC = {}. Non-conforming contact points: {}", (Object)this.localDc, (Object)nonLocalHosts);
        }
        if (notInLocalRack.size() > 0) {
            nonLocalHosts = Joiner.on((String)",").join(notInLocalRack);
            logger.warn("Some contact points don't match local rack. Local rack = {}. Non-conforming contact points: {}", (Object)this.localRack, (Object)nonLocalHosts);
        }
        this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
    }

    private String dc(Host host) {
        String dc = host.getDatacenter();
        return dc == null ? this.localDc : dc;
    }

    private String rack(Host host) {
        String rack = host.getRack();
        return rack == null ? this.localRack : rack;
    }

    private static CopyOnWriteArrayList<Host> cloneList(CopyOnWriteArrayList<Host> list) {
        return (CopyOnWriteArrayList)list.clone();
    }

    @Override
    public HostDistance distance(Host host) {
        String dc = this.dc(host);
        if (dc == UNSET || dc.equals(this.localDc)) {
            return HostDistance.LOCAL;
        }
        CopyOnWriteArrayList<Host> dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc);
        if (dcHosts == null || this.usedHostsPerRemoteDc == 0) {
            return HostDistance.IGNORED;
        }
        return (dcHosts = RackAwareRoundRobinPolicy.cloneList(dcHosts)).subList(0, Math.min(dcHosts.size(), this.usedHostsPerRemoteDc)).contains(host) ? HostDistance.REMOTE : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, final Statement statement) {
        CopyOnWriteArrayList localLiveHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.localDc);
        final CopyOnWriteArrayList<Host> copyLiveHostsLocalRackLocalDC = RackAwareRoundRobinPolicy.cloneList(this.liveHostsLocalRackLocalDC);
        final CopyOnWriteArrayList<Host> copyLiveHostsRemoteRacksLocalDC = RackAwareRoundRobinPolicy.cloneList(this.liveHostsRemoteRacksLocalDC);
        final int startIdx = this.index.getAndIncrement();
        return new AbstractIterator<Host>(){
            private int idx;
            private int remainingLiveHostsLocalRackLocalDC;
            private int remainingLiveHostsRemoteRacksLocalDC;
            private Iterator<String> remoteDcs;
            private List<Host> currentRemoteDcHosts;
            private int currentRemoteDcRemaining;
            {
                this.idx = startIdx;
                this.remainingLiveHostsLocalRackLocalDC = copyLiveHostsLocalRackLocalDC.size();
                this.remainingLiveHostsRemoteRacksLocalDC = copyLiveHostsRemoteRacksLocalDC.size();
            }

            protected Host computeNext() {
                while (true) {
                    ConsistencyLevel cl;
                    if (this.remainingLiveHostsLocalRackLocalDC > 0) {
                        int c;
                        --this.remainingLiveHostsLocalRackLocalDC;
                        if ((c = this.idx++ % copyLiveHostsLocalRackLocalDC.size()) < 0) {
                            c += copyLiveHostsLocalRackLocalDC.size();
                        }
                        return (Host)copyLiveHostsLocalRackLocalDC.get(c);
                    }
                    if (this.remainingLiveHostsRemoteRacksLocalDC > 0) {
                        int c;
                        --this.remainingLiveHostsRemoteRacksLocalDC;
                        if ((c = this.idx++ % copyLiveHostsRemoteRacksLocalDC.size()) < 0) {
                            c += copyLiveHostsRemoteRacksLocalDC.size();
                        }
                        return (Host)copyLiveHostsRemoteRacksLocalDC.get(c);
                    }
                    if (this.currentRemoteDcHosts != null && this.currentRemoteDcRemaining > 0) {
                        int c;
                        --this.currentRemoteDcRemaining;
                        if ((c = this.idx++ % this.currentRemoteDcHosts.size()) < 0) {
                            c += this.currentRemoteDcHosts.size();
                        }
                        return this.currentRemoteDcHosts.get(c);
                    }
                    ConsistencyLevel consistencyLevel = cl = statement.getConsistencyLevel() == null ? RackAwareRoundRobinPolicy.this.configuration.getQueryOptions().getConsistencyLevel() : statement.getConsistencyLevel();
                    if (RackAwareRoundRobinPolicy.this.dontHopForLocalCL && cl.isDCLocal()) {
                        return (Host)this.endOfData();
                    }
                    if (this.remoteDcs == null) {
                        HashSet copy = new HashSet(RackAwareRoundRobinPolicy.this.perDcLiveHosts.keySet());
                        copy.remove(RackAwareRoundRobinPolicy.this.localDc);
                        this.remoteDcs = copy.iterator();
                    }
                    if (!this.remoteDcs.hasNext()) break;
                    String nextRemoteDc = this.remoteDcs.next();
                    CopyOnWriteArrayList nextDcHosts = (CopyOnWriteArrayList)RackAwareRoundRobinPolicy.this.perDcLiveHosts.get(nextRemoteDc);
                    if (nextDcHosts == null) continue;
                    CopyOnWriteArrayList dcHosts = RackAwareRoundRobinPolicy.cloneList(nextDcHosts);
                    this.currentRemoteDcHosts = dcHosts.subList(0, Math.min(dcHosts.size(), RackAwareRoundRobinPolicy.this.usedHostsPerRemoteDc));
                    this.currentRemoteDcRemaining = this.currentRemoteDcHosts.size();
                }
                return (Host)this.endOfData();
            }
        };
    }

    @Override
    public void onUp(Host host) {
        CopyOnWriteArrayList<Host> newMap;
        CopyOnWriteArrayList<Host> dcHosts;
        String dc = this.dc(host);
        String rack = this.rack(host);
        if (this.localDc == UNSET && dc != UNSET) {
            logger.info("Using data-center name '{}' for RackAwareRoundRobinPolicy (if this is incorrect, please provide the correct datacenter name with RackAwareRoundRobinPolicy constructor)", (Object)dc);
            this.localDc = dc;
        }
        if (this.localRack == UNSET && rack != UNSET) {
            logger.info("Using rack name '{}' for RackAwareRoundRobinPolicy (if this is incorrect, please provide the correct datacenter name with RackAwareRoundRobinPolicy constructor)", (Object)rack);
            this.localRack = rack;
        }
        if ((dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc)) == null && (dcHosts = this.perDcLiveHosts.putIfAbsent(dc, newMap = new CopyOnWriteArrayList<Host>(Collections.singletonList(host)))) == null) {
            return;
        }
        dcHosts.addIfAbsent(host);
        if (dc.equals(this.localDc)) {
            if (rack.equals(this.localRack)) {
                this.liveHostsLocalRackLocalDC.add(host);
            } else {
                this.liveHostsRemoteRacksLocalDC.add(host);
            }
        }
    }

    @Override
    public void onDown(Host host) {
        String dc = this.dc(host);
        String rack = this.rack(host);
        CopyOnWriteArrayList dcHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(dc);
        if (dcHosts != null) {
            dcHosts.remove(host);
        }
        if (dc.equals(this.localDc)) {
            if (rack.equals(this.localRack)) {
                this.liveHostsLocalRackLocalDC.remove(host);
            } else {
                this.liveHostsRemoteRacksLocalDC.remove(host);
            }
        }
    }

    @Override
    public void onAdd(Host host) {
        this.onUp(host);
    }

    @Override
    public void onRemove(Host host) {
        this.onDown(host);
    }

    @Override
    public void close() {
    }

    public static class Builder {
        private String localDc;
        private String localRack;
        private int usedHostsPerRemoteDc;
        private boolean allowRemoteDCsForLocalConsistencyLevel;

        public Builder withLocalDc(String localDc) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)localDc) ? 1 : 0) != 0, (Object)"localDc name can't be null or empty. If you want to let the policy autodetect the datacenter, don't call Builder.withLocalDC");
            this.localDc = localDc;
            return this;
        }

        public Builder withLocalRack(String localRack) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)localRack) ? 1 : 0) != 0, (Object)"localRack name can't be null or empty. If you want to let the policy autodetect the rack, don't call Builder.withLocalRack");
            this.localRack = localRack;
            return this;
        }

        @Deprecated
        public Builder withUsedHostsPerRemoteDc(int usedHostsPerRemoteDc) {
            Preconditions.checkArgument((usedHostsPerRemoteDc >= 0 ? 1 : 0) != 0, (Object)"usedHostsPerRemoteDc must be equal or greater than 0");
            this.usedHostsPerRemoteDc = usedHostsPerRemoteDc;
            return this;
        }

        @Deprecated
        public Builder allowRemoteDCsForLocalConsistencyLevel() {
            this.allowRemoteDCsForLocalConsistencyLevel = true;
            return this;
        }

        public RackAwareRoundRobinPolicy build() {
            if (this.usedHostsPerRemoteDc == 0 && this.allowRemoteDCsForLocalConsistencyLevel) {
                logger.warn("Setting allowRemoteDCsForLocalConsistencyLevel has no effect if usedHostsPerRemoteDc = 0. This setting will be ignored");
            }
            return new RackAwareRoundRobinPolicy(this.localDc, this.localRack, this.usedHostsPerRemoteDc, this.allowRemoteDCsForLocalConsistencyLevel, true, true);
        }
    }
}

