/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;

public class DragGestureDetector {
    private final Context mContext;
    private final OnDragGestureListener mListener;
    private PointF mP0;
    private PointF mP1;
    private boolean mPointerDown;
    private boolean mGestureAcepted;
    private boolean mGestureInProgress;

    public DragGestureDetector(Context context, OnDragGestureListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 3: {
                this.cancelDrag();
                break;
            }
            case 1: {
                this.cancelDrag();
                break;
            }
            case 0: {
                this.cancelDrag();
                this.mPointerDown = true;
                break;
            }
            case 5: {
                this.mP0 = this.getFocusPoint(event);
                break;
            }
            case 6: {
                int index = (event.getAction() & 0xFF00) >> 8;
                this.mP0 = this.mP1 = this.getFocusPoint(event, index);
                break;
            }
            case 2: {
                if (!this.mPointerDown) break;
                this.mP1 = this.getFocusPoint(event);
                if (!this.mGestureInProgress) {
                    this.mGestureInProgress = true;
                    this.mGestureAcepted = this.mListener.onDragBegin(this);
                    if (!this.mGestureAcepted) break;
                    this.mP0 = this.getFocusPoint(event);
                    break;
                }
                if (!this.mGestureAcepted) break;
                this.mGestureAcepted = this.mListener.onDrag(this);
                if (!this.mGestureAcepted) break;
                this.mP0 = this.getFocusPoint(event);
            }
        }
        return false;
    }

    private PointF getFocusPoint(MotionEvent event, int ignore) {
        float x = 0.0f;
        float y = 0.0f;
        int n = event.getPointerCount();
        for (int i = 0; i < n; ++i) {
            if (i == ignore) continue;
            x += event.getX(i);
            y += event.getY(i);
        }
        return new PointF(x / (float)(n - 1), y / (float)(n - 1));
    }

    private PointF getFocusPoint(MotionEvent event) {
        float x = 0.0f;
        float y = 0.0f;
        int n = event.getPointerCount();
        for (int i = 0; i < n; ++i) {
            x += event.getX(i);
            y += event.getY(i);
        }
        return new PointF(x / (float)n, y / (float)n);
    }

    public float getDeltaY() {
        if (!this.mGestureInProgress) {
            return 0.0f;
        }
        return this.mP1.y - this.mP0.y;
    }

    public float getDeltaX() {
        if (!this.mGestureInProgress) {
            return 0.0f;
        }
        return this.mP1.x - this.mP0.x;
    }

    private void cancelDrag() {
        if (this.mGestureInProgress) {
            this.mGestureInProgress = false;
            if (this.mGestureAcepted) {
                this.mGestureAcepted = false;
                this.mListener.onDragEnd(this, true);
            }
        }
        this.mP0 = null;
        this.mP1 = null;
    }

    public static interface OnDragGestureListener {
        public boolean onDragBegin(DragGestureDetector var1);

        public boolean onDrag(DragGestureDetector var1);

        public void onDragEnd(DragGestureDetector var1, boolean var2);
    }
}

