/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;

public class RotateGestureDetector {
    private final Context mContext;
    private final OnRotateListener mListener;
    private PointF mPivot;
    private boolean mFingersReady;
    private float mRotation0;
    private float mRotation1;
    private boolean mGestureInProgress;
    private boolean mGestureAccepted;

    public RotateGestureDetector(Context context, OnRotateListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public float getDeltaRotation() {
        if (!this.mGestureInProgress) {
            return 0.0f;
        }
        return this.mRotation1 - this.mRotation0;
    }

    public PointF getPivot() {
        if (!this.mGestureInProgress) {
            return null;
        }
        return this.mPivot;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 3: {
                return this.cancel();
            }
            case 0: {
                this.reset();
                break;
            }
            case 1: {
                this.reset();
                break;
            }
            case 5: {
                boolean bl = this.mFingersReady = 2 == event.getPointerCount();
                if (!this.mFingersReady) break;
                this.mRotation0 = this.mRotation1 = RotateGestureDetector.getRotation(event);
                this.mPivot = RotateGestureDetector.getPivot(event);
                break;
            }
            case 6: {
                boolean bl = this.mFingersReady = 3 == event.getPointerCount();
                if (!this.mFingersReady) break;
                this.mRotation0 = this.mRotation1 = RotateGestureDetector.getRotation(event);
                this.mPivot = RotateGestureDetector.getPivot(event);
                break;
            }
            case 2: {
                if (!this.mFingersReady) {
                    return false;
                }
                this.mRotation1 = RotateGestureDetector.getRotation(event);
                if (!this.mGestureInProgress) {
                    this.mGestureInProgress = true;
                    this.mGestureAccepted = this.mListener.onRotateBegin(this);
                } else if (this.mGestureAccepted) {
                    this.mGestureAccepted = this.mListener.onRotate(this);
                }
                if (this.mGestureAccepted) {
                    this.mRotation0 = this.mRotation1;
                }
                return true;
            }
        }
        return false;
    }

    private static PointF getPivot(MotionEvent event) {
        return new PointF((event.getX(0) + event.getX(1)) / 2.0f, (event.getY(0) + event.getY(1)) / 2.0f);
    }

    private boolean cancel() {
        if (!this.mGestureInProgress) {
            return false;
        }
        this.mGestureInProgress = false;
        if (this.mGestureAccepted) {
            this.mListener.onRotateEnd(this);
            this.mGestureAccepted = false;
        }
        this.reset();
        return true;
    }

    private void reset() {
        this.mFingersReady = false;
        this.mGestureInProgress = false;
        this.mGestureAccepted = false;
        this.mRotation0 = 0.0f;
        this.mRotation1 = 0.0f;
        this.mPivot = null;
    }

    private static float getRotation(MotionEvent event) {
        double deltaX = event.getX(0) - event.getX(1);
        double deltaY = event.getY(0) - event.getY(1);
        double radians = Math.atan2(deltaY, deltaX);
        return (float)Math.toDegrees(radians);
    }

    public static interface OnRotateListener {
        public boolean onRotateBegin(RotateGestureDetector var1);

        public boolean onRotate(RotateGestureDetector var1);

        public void onRotateEnd(RotateGestureDetector var1);
    }
}

