/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.gesture;

import android.content.Context;
import android.view.MotionEvent;

public class ScaleGestureDetector {
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private final Context mContext;
    private final OnScaleGestureListener mListener;
    private boolean mGestureInProgress;
    private MotionEvent mPrevEvent;
    private MotionEvent mCurrEvent;
    private float mFocusX;
    private float mFocusY;
    private float mPrevFingerDiffX;
    private float mPrevFingerDiffY;
    private float mCurrFingerDiffX;
    private float mCurrFingerDiffY;
    private float mCurrLen;
    private float mPrevLen;
    private float mScaleFactor;
    private float mCurrPressure;
    private float mPrevPressure;
    private long mTimeDelta;
    private float mTopFingerBeginX;
    private float mTopFingerBeginY;
    private float mBottomFingerBeginX;
    private float mBottomFingerBeginY;
    private float mTopFingerCurrX;
    private float mTopFingerCurrY;
    private float mBottomFingerCurrX;
    private float mBottomFingerCurrY;
    private boolean mTopFingerIsPointer1;
    private boolean mPointerOneUp;
    private boolean mPointerTwoUp;

    public ScaleGestureDetector(Context context, OnScaleGestureListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (!this.mGestureInProgress) {
            if (action == 5) {
                // empty if block
            }
            if (action == 261) {
                // empty if block
            }
            if ((action == 5 || action == 261) && event.getPointerCount() >= 2) {
                this.mBottomFingerBeginX = event.getX(0);
                this.mBottomFingerBeginY = event.getY(0);
                this.mTopFingerBeginX = event.getX(1);
                this.mTopFingerBeginY = event.getY(1);
                this.mTopFingerCurrX = this.mTopFingerBeginX;
                this.mTopFingerCurrY = this.mTopFingerBeginY;
                this.mBottomFingerCurrX = this.mBottomFingerBeginX;
                this.mBottomFingerCurrY = this.mBottomFingerBeginY;
                this.mPointerOneUp = false;
                this.mPointerTwoUp = false;
                this.reset();
                this.mTopFingerIsPointer1 = !(this.mTopFingerBeginY > this.mBottomFingerBeginY);
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                this.mTimeDelta = 0L;
                this.setContext(event);
                this.mGestureInProgress = this.mListener.onScaleBegin(this);
            }
        } else {
            switch (action) {
                case 1: {
                    this.mPointerOneUp = true;
                    this.mPointerTwoUp = true;
                }
                case 6: {
                    if (this.mPointerOneUp) {
                        this.mPointerTwoUp = true;
                    }
                    this.mPointerOneUp = true;
                }
                case 262: {
                    if (action == 262) {
                        if (this.mPointerTwoUp) {
                            this.mPointerOneUp = true;
                        }
                        this.mPointerTwoUp = true;
                    }
                    if (!this.mPointerOneUp && !this.mPointerTwoUp) break;
                    this.setContext(event);
                    int id = (action & 0xFF00) >> 8 == 0 ? 1 : 0;
                    this.mFocusX = event.getX(id);
                    this.mFocusY = event.getY(id);
                    this.mListener.onScaleEnd(this, false);
                    this.mGestureInProgress = false;
                    this.reset();
                    break;
                }
                case 3: {
                    this.mListener.onScaleEnd(this, true);
                    this.mGestureInProgress = false;
                    this.reset();
                    break;
                }
                case 2: {
                    boolean updatePrevious;
                    this.setContext(event);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onScale(this))) break;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                }
            }
        }
        return false;
    }

    private void setContext(MotionEvent curr) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)curr);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        MotionEvent prev = this.mPrevEvent;
        float px0 = prev.getX(0);
        float py0 = prev.getY(0);
        float px1 = prev.getX(1);
        float py1 = prev.getY(1);
        float cx0 = curr.getX(0);
        float cy0 = curr.getY(0);
        float cx1 = curr.getX(1);
        float cy1 = curr.getY(1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.mPrevFingerDiffX = pvx;
        this.mPrevFingerDiffY = pvy;
        this.mCurrFingerDiffX = cvx;
        this.mCurrFingerDiffY = cvy;
        this.mFocusX = cx0 + cvx * 0.5f;
        this.mFocusY = cy0 + cvy * 0.5f;
        this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
        this.mCurrPressure = curr.getPressure(0) + curr.getPressure(1);
        this.mPrevPressure = prev.getPressure(0) + prev.getPressure(1);
        this.mBottomFingerCurrX = cx0;
        this.mBottomFingerCurrY = cy0;
        this.mTopFingerCurrX = cx1;
        this.mTopFingerCurrY = cy1;
    }

    private void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float cvx = this.mCurrFingerDiffX;
            float cvy = this.mCurrFingerDiffY;
            this.mCurrLen = (float)Math.sqrt(cvx * cvx + cvy * cvy);
        }
        return this.mCurrLen;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float pvx = this.mPrevFingerDiffX;
            float pvy = this.mPrevFingerDiffY;
            this.mPrevLen = (float)Math.sqrt(pvx * pvx + pvy * pvy);
        }
        return this.mPrevLen;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public float getTopFingerX() {
        return this.mTopFingerIsPointer1 ? this.mTopFingerCurrX : this.mBottomFingerCurrX;
    }

    public float getTopFingerY() {
        return this.mTopFingerIsPointer1 ? this.mTopFingerCurrY : this.mBottomFingerCurrY;
    }

    public float getTopFingerDeltaX() {
        return this.mTopFingerIsPointer1 ? this.mTopFingerCurrX - this.mTopFingerBeginX : this.mBottomFingerCurrX - this.mBottomFingerBeginX;
    }

    public float getTopFingerDeltaY() {
        return this.mTopFingerIsPointer1 ? this.mTopFingerCurrY - this.mTopFingerBeginY : this.mBottomFingerCurrY - this.mBottomFingerBeginY;
    }

    public float getBottomFingerX() {
        return !this.mTopFingerIsPointer1 ? this.mTopFingerCurrX : this.mBottomFingerCurrX;
    }

    public float getBottomFingerY() {
        return !this.mTopFingerIsPointer1 ? this.mTopFingerCurrY : this.mBottomFingerCurrY;
    }

    public float getBottomFingerDeltaX() {
        return !this.mTopFingerIsPointer1 ? this.mTopFingerCurrX - this.mTopFingerBeginX : this.mBottomFingerCurrX - this.mBottomFingerBeginX;
    }

    public float getBottomFingerDeltaY() {
        return !this.mTopFingerIsPointer1 ? this.mTopFingerCurrY - this.mTopFingerBeginY : this.mBottomFingerCurrY - this.mBottomFingerBeginY;
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        @Override
        public boolean onScale(ScaleGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector detector, boolean cancel) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1, boolean var2);
    }
}

