/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net;

import com.sdklite.net.MalformedMimeTypeException;
import java.io.File;
import java.io.Serializable;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MimeType
implements Serializable {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "(\"[^\"]*\")";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|(\"[^\"]*\")))?");
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    public static MimeType parse(String string) throws MalformedMimeTypeException {
        Matcher typeMatcher = TYPE_SUBTYPE.matcher(string);
        if (!typeMatcher.lookingAt()) {
            return null;
        }
        String type = typeMatcher.group(1).toLowerCase(Locale.US);
        String subtype = typeMatcher.group(2).toLowerCase(Locale.US);
        Matcher parametersMatcher = PARAMETER.matcher(string);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        int i = typeMatcher.end();
        int n = string.length();
        while (i < n) {
            parametersMatcher.region(i, string.length());
            if (!parametersMatcher.lookingAt()) {
                throw new MalformedMimeTypeException(string);
            }
            String name = parametersMatcher.group(1);
            if (name != null) {
                String value = parametersMatcher.group(2) != null ? parametersMatcher.group(2) : parametersMatcher.group(3);
                parameters.put(name, value);
            }
            i = parametersMatcher.end();
        }
        return new MimeType(type, subtype, parameters);
    }

    public static final MimeType guess(File file) {
        return MimeType.guess(file, null);
    }

    public static final MimeType guess(File file, MimeType defaultType) {
        return MimeType.guess(file.getName(), defaultType);
    }

    public static final MimeType guess(String url) {
        return MimeType.guess(url, null);
    }

    public static final MimeType guess(String url, MimeType defaultType) {
        if (null == url) {
            return defaultType;
        }
        String contentType = URLConnection.guessContentTypeFromName(url);
        if (null != contentType) {
            return MimeType.parse(contentType);
        }
        return defaultType;
    }

    public MimeType(MimeType mimeType) {
        this.type = mimeType.type;
        this.subtype = mimeType.subtype;
        this.parameters = Collections.unmodifiableMap(mimeType.parameters);
    }

    public MimeType(String type) throws MalformedMimeTypeException {
        this(type, "*");
    }

    public MimeType(String type, String subtype) throws MalformedMimeTypeException {
        this(type, subtype, Collections.emptyMap());
    }

    public MimeType(String type, String subtype, Map<String, String> parameters) throws MalformedMimeTypeException {
        if (null == type) {
            throw new IllegalArgumentException("Type is required");
        }
        if (!type.matches(TOKEN)) {
            throw new MalformedMimeTypeException("Malformed type: " + type);
        }
        if (null != subtype && !subtype.matches(TOKEN)) {
            throw new MalformedMimeTypeException("Malformed subtype: " + subtype);
        }
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String name = parameter.getKey();
            String value = parameter.getValue();
            if (!name.matches(TOKEN)) {
                throw new MalformedMimeTypeException("Malformed parameter name: " + name);
            }
            if (value.matches("(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|(\"[^\"]*\"))")) continue;
            throw new MalformedMimeTypeException("Malformed parameter value: " + value);
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                if ("charset".equalsIgnoreCase(a) && "charset".equalsIgnoreCase(b)) {
                    return 0;
                }
                return a.compareTo(b);
            }
        });
        sorted.putAll(parameters);
        this.type = type;
        this.subtype = subtype;
        this.parameters = Collections.unmodifiableMap(sorted);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public String getParameter(String name) {
        String value = this.parameters.get(name);
        if (null != value && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public Charset getCharset() {
        return Charset.forName(this.getParameter("charset", "US-ASCII"));
    }

    public Charset getCharset(Charset defaultCharset) {
        String charsetName = this.getParameter("charset");
        if (null != charsetName) {
            return Charset.forName(charsetName);
        }
        return defaultCharset;
    }

    public boolean isWildcardType() {
        return "*".equals(this.type);
    }

    public boolean isWildcardSubtype() {
        return null != this.subtype && this.subtype.startsWith("*");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.type);
        if (null != this.subtype) {
            builder.append("/").append(this.subtype);
        }
        if (this.parameters.size() > 0) {
            for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
                String name = parameter.getKey();
                String value = parameter.getValue();
                builder.append("; ").append("charset".equalsIgnoreCase(name) ? "charset" : name).append("=").append(value);
            }
        }
        return builder.toString();
    }
}

