/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.MimeType;
import com.sdklite.net.http.Constants;
import com.sdklite.net.http.PartBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ByteArrayPartBody
extends PartBody {
    private final byte[] data;
    private final int offset;
    private final int length;

    public ByteArrayPartBody(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteArrayPartBody(byte[] data, int offset, int length) {
        this(data, offset, length, Constants.APPLICATION_OCTET_STREAM, null);
    }

    public ByteArrayPartBody(byte[] data, MimeType contentType) {
        this(data, 0, data.length, contentType, null);
    }

    public ByteArrayPartBody(byte[] data, int offset, int length, MimeType contentType) {
        this(data, offset, length, contentType, null);
    }

    public ByteArrayPartBody(byte[] data, MimeType contentType, String filename) {
        this(data, 0, data.length, contentType, filename);
    }

    public ByteArrayPartBody(byte[] data, int offset, int length, MimeType contentType, String filename) {
        super(contentType, filename);
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.data, this.offset, this.length);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data, this.offset, this.length);
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public String getContentTransferEncoding() {
        return "binary";
    }
}

