/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.MimeType;
import com.sdklite.net.http.Constants;
import com.sdklite.net.http.HttpBody;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormBody
extends HttpBody {
    private final Map<String, List<String>> values;

    private FormBody(Builder builder) {
        this.values = Collections.unmodifiableMap(builder.values);
    }

    public Set<String> getNames() {
        return this.values.keySet();
    }

    public List<String> getValues(String name) {
        if (this.values.containsKey(name)) {
            return this.values.get(name);
        }
        return Collections.emptyList();
    }

    @Override
    public MimeType getContentType() {
        return MimeType.parse("application/x-www-form-urlencoded");
    }

    @Override
    public InputStream getContent() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Iterator<Map.Entry<String, List<String>>> i = this.values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, List<String>> entry = i.next();
            String name = entry.getKey();
            Iterator<String> j = entry.getValue().iterator();
            while (j.hasNext()) {
                String value = j.next();
                out.write(URLEncoder.encode(name, "UTF-8").getBytes(Constants.UTF_8));
                out.write(61);
                out.write(URLEncoder.encode(value, "UTF-8").getBytes(Constants.UTF_8));
                if (!j.hasNext()) continue;
                out.write(38);
            }
            if (!i.hasNext()) continue;
            out.write(38);
        }
        out.flush();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private final Map<String, List<String>> values = new LinkedHashMap<String, List<String>>();

        public Builder() {
        }

        private Builder(FormBody form) {
            this.values.putAll(form.values);
        }

        public Builder add(String name, String ... values) {
            ArrayList<String> list = this.values.containsKey(name) ? this.values.get(name) : new ArrayList<String>();
            list.addAll(Arrays.asList(values));
            this.values.put(name, list);
            return this;
        }

        public FormBody build() {
            return new FormBody(this);
        }
    }
}

