/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.io.IOUtil;
import com.sdklite.net.MimeType;
import com.sdklite.net.http.Constants;
import com.sdklite.net.http.HttpEntity;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class HttpBody
implements HttpEntity {
    public static HttpBody newInstance(final MimeType contentType, final byte[] buf, final int offset, final int length) {
        return new HttpBody(){

            @Override
            public MimeType getContentType() {
                return contentType;
            }

            @Override
            public long getContentLength() {
                return length;
            }

            @Override
            public InputStream getContent() {
                return new ByteArrayInputStream(buf, offset, length);
            }
        };
    }

    public static HttpBody newInstance(String contentType, byte[] buf, int offset, int length) {
        return HttpBody.newInstance(MimeType.parse(contentType), buf, offset, length);
    }

    public static HttpBody newInstance(MimeType contentType, byte[] buf) {
        return HttpBody.newInstance(contentType, buf, 0, buf.length);
    }

    public static HttpBody newInstance(String contentType, byte[] buf) {
        return HttpBody.newInstance(MimeType.parse(contentType), buf);
    }

    public static HttpBody newInstance(MimeType contentType, String s) {
        return HttpBody.newInstance(contentType, s.getBytes(contentType.getCharset(Constants.UTF_8)));
    }

    public static HttpBody newInstance(String contentType, String s) {
        return HttpBody.newInstance(MimeType.parse(contentType), s);
    }

    public static HttpBody newInstance(final MimeType contentType, final File file) {
        return new HttpBody(){

            @Override
            public MimeType getContentType() {
                return contentType;
            }

            @Override
            public long getContentLength() {
                return file.length();
            }

            @Override
            public InputStream getContent() throws FileNotFoundException {
                return new FileInputStream(file);
            }
        };
    }

    public static HttpBody newInstance(String contentType, File file) {
        return HttpBody.newInstance(MimeType.parse(contentType), file);
    }

    protected HttpBody() {
    }

    @Override
    public Charset getCharset() {
        MimeType contentType = this.getContentType();
        if (null != contentType) {
            return contentType.getCharset();
        }
        return null;
    }

    public Charset getCharset(Charset defaultCharset) {
        Charset charset = this.getCharset();
        if (null != charset) {
            return charset;
        }
        return defaultCharset;
    }

    @Override
    public long getContentLength() throws IOException {
        return -1L;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        IOUtil.copy((InputStream)this.getContent(), (OutputStream)out);
    }
}

