/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.http.HttpHeader;
import com.sdklite.net.http.HttpMessage;
import com.sdklite.net.http.SimpleHttpHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class HttpHeaders {
    private static final Comparator<String> HEADER_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a == b ? 0 : (null == a ? -1 : (null == b ? 1 : String.CASE_INSENSITIVE_ORDER.compare(a, b)));
        }
    };

    public static Map<String, List<String>> getHeaders(HttpMessage message) {
        TreeMap map = new TreeMap(HEADER_NAME_COMPARATOR);
        for (HttpHeader header : message.getHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            List<String> values = map.containsKey(name) ? (List)map.get(name) : new ArrayList();
            values.add(value);
            map.put(name, values);
        }
        return Collections.unmodifiableMap(map);
    }

    public static long getContentLength(HttpMessage message) {
        String contentLength = message.getHeader("Content-Length");
        if (null == contentLength) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static HttpHeader parse(String header) {
        int colon = header.indexOf(58);
        if (colon < 1 || colon == header.length() - 1) {
            throw new IllegalArgumentException("Malformed HTTP header");
        }
        return new SimpleHttpHeader(header.substring(0, colon).trim(), header.substring(colon + 1).trim());
    }

    private HttpHeaders() {
    }
}

