/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.http.HttpEntity;
import com.sdklite.net.http.HttpHeader;
import com.sdklite.net.http.SimpleHttpHeader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class HttpMessage {
    protected final List<HttpHeader> headers;
    protected final HttpEntity entity;

    protected HttpMessage(Builder builder) {
        this.headers = Collections.unmodifiableList(builder.headers);
        this.entity = builder.entity;
    }

    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public List<HttpHeader> getHeaders(String name) {
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
        for (HttpHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            headers.add(header);
        }
        return Collections.unmodifiableList(headers);
    }

    public String getHeader(String name) {
        for (HttpHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header.getValue();
        }
        return null;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public abstract Builder newBuilder();

    public static abstract class Builder {
        protected final List<HttpHeader> headers = new ArrayList<HttpHeader>();
        protected HttpEntity entity;

        public Builder() {
        }

        protected Builder(HttpMessage message) {
            this.headers.addAll(message.headers);
            this.entity = message.entity;
        }

        public List<? extends HttpHeader> getHeaders() {
            return this.headers;
        }

        public List<String> getHeaders(String name) {
            ArrayList<String> headers = new ArrayList<String>();
            for (HttpHeader header : this.headers) {
                if (!header.getName().equalsIgnoreCase(name)) continue;
                headers.add(header.getValue());
            }
            return headers;
        }

        public String getHeader(String name) {
            for (HttpHeader header : this.headers) {
                if (!header.getName().equalsIgnoreCase(name)) continue;
                return header.getValue();
            }
            return null;
        }

        public Builder addHeaders(HttpHeader ... headers) {
            this.headers.addAll(Arrays.asList(headers));
            return this;
        }

        public Builder addHeaders(Iterable<HttpHeader> headers) {
            for (HttpHeader header : headers) {
                this.headers.add(header);
            }
            return this;
        }

        public Builder addHeader(String name, String value) {
            return this.addHeaders(new SimpleHttpHeader(name, value));
        }

        public Builder removeHeader(String name) {
            Iterator<HttpHeader> i = this.headers.iterator();
            while (i.hasNext()) {
                HttpHeader header = i.next();
                if (!header.getName().equalsIgnoreCase(name)) continue;
                i.remove();
            }
            return this;
        }

        public Builder setEntity(HttpEntity entity) {
            this.entity = entity;
            return this;
        }

        public abstract HttpMessage build();
    }
}

