/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.http.HttpEntity;
import com.sdklite.net.http.HttpHeader;
import com.sdklite.net.http.HttpMessage;
import com.sdklite.net.http.HttpMethod;

public class HttpRequest
extends HttpMessage {
    private final HttpMethod method;
    private final String url;

    private HttpRequest(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.method = builder.method;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSecure() {
        int colon = this.url.indexOf(":");
        if (colon > 0 && colon < this.url.length()) {
            return "https".equalsIgnoreCase(this.url.substring(0, colon));
        }
        return false;
    }

    @Override
    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends HttpMessage.Builder {
        private String url;
        private HttpMethod method;

        public Builder() {
        }

        private Builder(HttpRequest request) {
            super(request);
        }

        public Builder setMethod(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        @Override
        public Builder addHeaders(HttpHeader ... headers) {
            super.addHeaders(headers);
            return this;
        }

        @Override
        public Builder addHeader(String name, String value) {
            super.addHeader(name, value);
            return this;
        }

        @Override
        public Builder setEntity(HttpEntity entity) {
            super.setEntity(entity);
            return this;
        }

        @Override
        public HttpRequest build() {
            return new HttpRequest(this);
        }
    }
}

