/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.http.HttpEntity;
import com.sdklite.net.http.HttpHeader;
import com.sdklite.net.http.HttpMessage;

public class HttpResponse
extends HttpMessage {
    public static final int HTTP_TEMP_REDIRECT = 307;
    public static final int HTTP_PERM_REDIRECT = 308;
    private final String protocol;
    private final int statusCode;
    private final String reasonPhrase;

    private HttpResponse(Builder builder) {
        super(builder);
        this.protocol = builder.protocol;
        this.statusCode = builder.statusCode;
        this.reasonPhrase = builder.reasonPhrase;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public boolean isRedirect() {
        switch (this.statusCode) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends HttpMessage.Builder {
        private String protocol;
        private int statusCode;
        private String reasonPhrase;

        public Builder() {
        }

        private Builder(HttpResponse response) {
            super(response);
        }

        @Override
        public Builder addHeaders(HttpHeader ... headers) {
            super.addHeaders(headers);
            return this;
        }

        @Override
        public Builder addHeader(String name, String value) {
            super.addHeader(name, value);
            return this;
        }

        @Override
        public Builder setEntity(HttpEntity entity) {
            super.setEntity(entity);
            return this;
        }

        public Builder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setReasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
            return this;
        }

        @Override
        public HttpResponse build() {
            return new HttpResponse(this);
        }
    }
}

