/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.MimeType;
import com.sdklite.net.http.ByteArrayPartBody;
import com.sdklite.net.http.FilePartBody;
import com.sdklite.net.http.HttpBody;
import com.sdklite.net.http.HttpHeader;
import com.sdklite.net.http.InputStreamPartBody;
import com.sdklite.net.http.Part;
import com.sdklite.net.http.PartEntity;
import com.sdklite.net.http.StringPartBody;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class MultipartBody
extends HttpBody {
    private static final byte[] DASHES = "--".getBytes();
    private static final byte[] CR_LF = "\r\n".getBytes();
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final Charset charset;
    private final String boundary;
    private final List<Part> parts;

    static String generateBoundary() {
        StringBuilder buffer = new StringBuilder();
        Random rand = new Random();
        int count = rand.nextInt(11) + 30;
        for (int i = 0; i < count; ++i) {
            buffer.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        return buffer.toString();
    }

    private MultipartBody(Builder builder) {
        this.charset = builder.charset;
        this.boundary = builder.boundary;
        this.parts = Collections.unmodifiableList(builder.parts);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    @Override
    public MimeType getContentType() {
        StringBuilder builder = new StringBuilder();
        builder.append("multipart/form-data; boundary=").append(this.boundary);
        if (null != this.charset) {
            builder.append("; charset=").append(this.charset.name());
        }
        return MimeType.parse(builder.toString());
    }

    @Override
    public InputStream getContent() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        byte[] boundary = this.boundary.getBytes();
        for (Part part : this.parts) {
            out.write(DASHES);
            out.write(boundary);
            out.write(CR_LF);
            for (HttpHeader header : part.getHeaders()) {
                out.write(header.toString().getBytes());
                out.write(CR_LF);
            }
            out.write(CR_LF);
            part.getEntity().writeTo(out);
            out.write(CR_LF);
        }
        out.write(DASHES);
        out.write(boundary);
        out.write(DASHES);
        out.write(CR_LF);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private Charset charset = Charset.defaultCharset();
        private String boundary = MultipartBody.generateBoundary();
        private final List<Part> parts = new ArrayList<Part>();

        public Builder() {
        }

        private Builder(MultipartBody body) {
            this.charset = body.charset;
            this.boundary = body.boundary;
            this.parts.addAll(body.parts);
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getBoundary() {
            return this.boundary;
        }

        public List<Part> getParts() {
            return this.parts;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder setBoundary(String boundary) {
            this.boundary = boundary;
            return this;
        }

        public Builder addPart(Part part) {
            this.parts.add(part);
            return this;
        }

        public Builder addPart(String name, PartEntity entity) {
            return this.addPart(new Part.Builder().setName(name).setEntity(entity).build());
        }

        public Builder addPart(String name, byte[] data) {
            return this.addPart(name, new ByteArrayPartBody(data));
        }

        public Builder addPart(String name, byte[] data, MimeType contentType) {
            return this.addPart(name, new ByteArrayPartBody(data, contentType));
        }

        public Builder addPart(String name, File file) {
            return this.addPart(name, new FilePartBody(file));
        }

        public Builder addPart(String name, File file, MimeType contentType) {
            return this.addPart(name, new FilePartBody(file, contentType));
        }

        public Builder addPart(String name, String text) {
            return this.addPart(name, new StringPartBody(text));
        }

        public Builder addPart(String name, String text, MimeType contentType) {
            return this.addPart(name, new StringPartBody(text, contentType));
        }

        public Builder addPart(String name, InputStream value) {
            return this.addPart(name, new InputStreamPartBody(value));
        }

        public MultipartBody build() {
            return new MultipartBody(this);
        }
    }
}

