/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.http.HttpEntity;
import com.sdklite.net.http.HttpHeader;
import com.sdklite.net.http.HttpMessage;
import com.sdklite.net.http.PartEntity;

public class Part
extends HttpMessage {
    private final String name;

    private Part(Builder builder) {
        super(builder);
        this.name = builder.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public PartEntity getEntity() {
        return (PartEntity)super.getEntity();
    }

    @Override
    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends HttpMessage.Builder {
        private String name;

        public Builder() {
        }

        private Builder(Part part) {
            super(part);
            this.name = part.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder addHeaders(HttpHeader ... headers) {
            super.addHeaders(headers);
            return this;
        }

        @Override
        public Builder addHeader(String name, String value) {
            super.addHeader(name, value);
            return this;
        }

        @Override
        public Builder setEntity(HttpEntity entity) {
            super.setEntity(entity);
            return this;
        }

        @Override
        public Part build() {
            this.addHeader("Content-Disposition", this.getContentDisposition());
            this.addHeader("Content-Type", this.getContentType());
            this.addHeader("Content-Transfer-Encoding", this.getContentTransferEncoding());
            return new Part(this);
        }

        private String getContentDisposition() {
            String filename;
            StringBuilder builder = new StringBuilder();
            builder.append("form-data; name=\"").append(this.name).append("\"");
            if (this.entity instanceof PartEntity && null != (filename = ((PartEntity)this.entity).getFilename())) {
                builder.append("; filename=\"").append(filename).append("\"");
            }
            return builder.toString();
        }

        private String getContentType() {
            return this.entity.getContentType().toString();
        }

        private String getContentTransferEncoding() {
            if (this.entity instanceof PartEntity) {
                return ((PartEntity)this.entity).getContentTransferEncoding();
            }
            return "7bit";
        }
    }
}

