/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.io.IOUtil;
import com.sdklite.net.MimeType;
import com.sdklite.net.http.Constants;
import com.sdklite.net.http.PartEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

abstract class PartBody
implements PartEntity {
    private final MimeType contentType;
    private final String filename;

    public PartBody(MimeType contentType, String filename) {
        this.contentType = null != contentType ? contentType : (null != filename ? MimeType.guess(filename, Constants.APPLICATION_OCTET_STREAM) : Constants.APPLICATION_OCTET_STREAM);
        this.filename = filename;
    }

    @Override
    public final MimeType getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentTransferEncoding() {
        return "7bit";
    }

    @Override
    public Charset getCharset() {
        return this.getContentType().getCharset(Constants.ISO_8859_1);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        IOUtil.copy((InputStream)this.getContent(), (OutputStream)out);
    }

    @Override
    public final String getFilename() {
        return this.filename;
    }
}

