/*
 * Decompiled with CFR 0.152.
 */
package com.sdklite.net.http;

import com.sdklite.net.MimeType;
import com.sdklite.net.http.Constants;
import com.sdklite.net.http.PartBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

class StringPartBody
extends PartBody {
    private final byte[] text;

    public StringPartBody(String text) {
        this(text, Constants.TEXT_PLAIN, null);
    }

    public StringPartBody(String text, MimeType contentType) {
        this(text, contentType, null);
    }

    public StringPartBody(String text, MimeType contentType, String filename) {
        super(contentType, filename);
        Charset charset = contentType.getCharset(Constants.US_ASCII);
        this.text = text.getBytes(charset);
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.text);
    }

    @Override
    public long getContentLength() {
        return this.text.length;
    }

    @Override
    public String getContentTransferEncoding() {
        return "8bit";
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.text);
    }
}

