/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.api.dynamic;

import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.web.api.content.BinaryContentRetriever;
import com.sdl.web.content.client.impl.ContentClientProvider;
import com.sdl.web.content.client.impl.ODataV2ClientQuery;
import com.sdl.web.content.client.odata.v2.edm.BinaryContent;
import com.sdl.web.content.client.util.MapperFactory;
import com.tridion.data.BinaryData;
import com.tridion.util.BinaryVariantUtils;
import com.tridion.util.CMURI;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryContentRetrieverImpl
implements BinaryContentRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryContentRetrieverImpl.class);
    private static final String EMPTY = "";

    public BinaryData getBinary(String binaryURI) {
        LOG.debug("Getting default binary for binaryURI={}.", (Object)binaryURI);
        try {
            CMURI parsedBinaryURI = new CMURI(binaryURI);
            return this.getBinary(parsedBinaryURI.getPublicationId(), parsedBinaryURI.getItemId());
        }
        catch (ParseException e) {
            LOG.error("Unable to parse the given binaryURI.", (Throwable)e);
            return null;
        }
    }

    public BinaryData getBinary(String binaryURI, String variantId) {
        LOG.debug("Getting binary for binaryURI={} and variantid={}.", (Object)binaryURI, (Object)variantId);
        try {
            CMURI parsedBinaryURI = new CMURI(binaryURI);
            return this.getBinary(parsedBinaryURI.getPublicationId(), parsedBinaryURI.getItemId(), variantId);
        }
        catch (ParseException e) {
            LOG.error("Unable to parse the given binaryURI.", (Throwable)e);
            return null;
        }
    }

    public BinaryData getBinary(int publicationId, int binaryId) {
        LOG.debug("Getting default binary for publicationId={} and binaryId={}.", (Object)publicationId, (Object)binaryId);
        return this.getBinary(publicationId, binaryId, EMPTY);
    }

    public BinaryData getBinary(int publicationId, int binaryId, String variantId) {
        LOG.debug("Searching for binaryData for publicationId='{}', binaryId='{}', variantId='{}'.", new Object[]{publicationId, binaryId, variantId});
        try {
            ODataClientQuery query = new ODataV2ClientQuery.Builder().withEntityType(BinaryContent.class).withEntityParameterMap("PublicationId", EMPTY + publicationId).withEntityParameterMap("BinaryId", EMPTY + binaryId).withEntityParameterMap("VariantId", com.sdl.web.content.util.BinaryVariantUtils.denormalizeAndEncodeWebServiceVariantId((String)variantId)).withEntityParameterMap("StreamContent", Boolean.FALSE.toString()).build();
            BinaryContent binaryContent = (BinaryContent)ContentClientProvider.getInstance().getContentClient().getEntity(BinaryContent.class.getName(), query);
            if (binaryContent != null) {
                BinaryContent clonedBinaryContent = new BinaryContent(binaryContent);
                LOG.trace("BinaryContent for publicationId='{}', binaryId='{}', variantId='{}' is '{}'.", new Object[]{publicationId, binaryId, variantId, binaryContent});
                String fixedVariantId = BinaryVariantUtils.isEmptyVariantId((String)variantId) ? EMPTY : com.sdl.web.content.util.BinaryVariantUtils.decodeAndNormalizeWebServiceVariantId((String)binaryContent.getVariantId());
                LOG.debug("Setting VariantId='{}' for binaryId='{}'", (Object)fixedVariantId, (Object)binaryId);
                clonedBinaryContent.setVariantId(fixedVariantId);
                return MapperFactory.mapBinaryData((BinaryContent)clonedBinaryContent);
            }
        }
        catch (ODataClientRuntimeException e) {
            LOG.error("BinaryDataResolver: Could not query by publicationId='{}', binaryId='{}', variantId='{}'", new Object[]{publicationId, binaryId, variantId, e});
        }
        return null;
    }
}

