/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.api.dynamic;

import com.sdl.odata.client.FunctionImportClientQuery;
import com.sdl.web.api.dynamic.WebComponentPresentationAssembler;
import com.sdl.web.content.client.impl.ContentClientProvider;
import com.sdl.web.content.client.util.ContentServiceClientUtil;
import com.tridion.util.CMURI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentPresentationAssemblerImpl
implements WebComponentPresentationAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentPresentationAssemblerImpl.class);
    private int publicationId = -1;
    private int pageId = -1;

    public ComponentPresentationAssemblerImpl(int publicationId) {
        this.publicationId = publicationId;
    }

    public ComponentPresentationAssemblerImpl(int publicationId, int pageId) {
        this.publicationId = publicationId;
        this.pageId = pageId;
    }

    public ComponentPresentationAssemblerImpl(String itemURI) {
        try {
            CMURI parsedItemURI = new CMURI(itemURI);
            this.publicationId = parsedItemURI.getPublicationId();
        }
        catch (ParseException e) {
            LOG.warn("Unable to parse the itemURI for the publicationId", (Object)e.getMessage());
        }
    }

    public String getContent(int componentId, int componentTemplateId) {
        return this.getContent(componentId, componentTemplateId, new HashMap<String, String>());
    }

    public String getContent(int componentId, int componentTemplateId, Map<String, String> renderParameters) {
        FunctionImportClientQuery.Builder functionQueryBuilder = new FunctionImportClientQuery.Builder().withEntityType(String.class).withFunctionName("GetComponentPresentationContentFunctionImport").withFunctionParameter("PublicationId", "" + this.publicationId).withFunctionParameter("ComponentId", "" + componentId).withFunctionParameter("ComponentTemplateId", "" + componentTemplateId);
        if (!renderParameters.isEmpty()) {
            String renderParametersString = renderParameters.entrySet().stream().map(keyValue -> (String)keyValue.getKey() + "=" + (String)keyValue.getValue()).collect(Collectors.joining(";"));
            functionQueryBuilder.withFunctionParameter("RenderParameters", ContentServiceClientUtil.encloseWithinQuotes((String)renderParametersString));
        }
        if (this.pageId > 0) {
            functionQueryBuilder.withFunctionParameter("PageId", "" + this.pageId);
        }
        return StringEscapeUtils.unescapeHtml4((String)((String)ContentClientProvider.getInstance().getContentClient().getEntity("Edm.String", functionQueryBuilder.build())));
    }

    public String getContent(String componentURI, String componentTemplateURI, Map<String, String> renderingParameters) {
        try {
            CMURI cURI = new CMURI(componentURI);
            CMURI ctURI = new CMURI(componentTemplateURI);
            int componentId = cURI.getItemId();
            int componentTemplateId = ctURI.getItemId();
            return this.getContent(componentId, componentTemplateId);
        }
        catch (ParseException e) {
            LOG.error("ComponentPresentationAssembler:getContent(String, String) got invalid uri's as parameter, returning \"\"");
            return "";
        }
    }

    public String getContent(String componentURI, String componentTemplateURI) {
        return this.getContent(componentURI, componentTemplateURI, new HashMap<String, String>());
    }
}

