/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.api.dynamic;

import com.sdl.odata.client.FunctionImportClientQuery;
import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.web.api.dynamic.DynamicMetaRetriever;
import com.sdl.web.broker.serialization.item.BinaryMetaSerializer;
import com.sdl.web.broker.serialization.item.ItemDto;
import com.sdl.web.broker.serialization.item.ItemSerializer;
import com.sdl.web.content.client.dataloader.ODataClientDataLoader;
import com.sdl.web.content.client.impl.ContentClientProvider;
import com.sdl.web.content.client.taxonomies.mapper.LazyKeywordImpl;
import com.sdl.web.content.client.util.ContentServiceClientUtil;
import com.sdl.web.model.BrokerAPIClassesProvider;
import com.sdl.web.model.PageMetaImpl;
import com.sdl.web.util.ContentClientDataLoader;
import com.tridion.meta.BinaryMeta;
import com.tridion.meta.PageMeta;
import com.tridion.taxonomies.Keyword;
import com.tridion.util.StringUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMetaRetrieverImpl
implements DynamicMetaRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMetaRetrieverImpl.class);
    private static final ItemSerializer ITEM_SERIALIZER = new ItemSerializer(BrokerAPIClassesProvider.getItemClasses(), (ContentClientDataLoader)new ODataClientDataLoader());

    public PageMeta getPageMetaByURL(String urlPath) {
        LOG.debug("Searching for pageMeta for url='{}'.", (Object)urlPath);
        ODataClientQuery clientQuery = new FunctionImportClientQuery.Builder().withEntityType(String.class).withFunctionName("GetDynamicMetaFunctionImport").withFunctionParameter("Url", "'" + urlPath + "'").withFunctionParameter("ItemType", "'PageMeta'").build();
        String result = (String)ContentClientProvider.getInstance().getContentClient().getEntity("Edm.String", clientQuery);
        if (StringUtils.isNotEmpty((String[])new String[]{result})) {
            ItemDto dto = new ItemDto(PageMetaImpl.class, result);
            try {
                PageMeta pageMeta = (PageMeta)ITEM_SERIALIZER.deserialize(dto);
                LOG.debug("Retrieved PageMeta instance: {}", (Object)pageMeta);
                Arrays.stream(pageMeta.getCategories()).forEach(category -> category.setKeywords((Keyword[])Arrays.stream(category.getKeywordList()).map(keyword -> new LazyKeywordImpl(keyword.getTaxonomyURI(), keyword.getKeywordURI(), keyword.getKeywordName())).toArray(Keyword[]::new)));
                return pageMeta;
            }
            catch (ClassNotFoundException e) {
                LOG.error("Could not load PageMetaImpl model classes", (Throwable)e);
            }
        } else {
            LOG.debug("Could not find page metadata by url: {}", (Object)urlPath);
        }
        return null;
    }

    public BinaryMeta getBinaryMetaByURL(String urlPath) {
        LOG.debug("Searching for binaryMeta for url='{}'.", (Object)urlPath);
        ODataClientQuery clientQuery = new FunctionImportClientQuery.Builder().withEntityType(String.class).withFunctionName("GetDynamicMetaFunctionImport").withFunctionParameter("Url", ContentServiceClientUtil.encloseWithinQuotesDoubleEncoded((String)urlPath)).withFunctionParameter("ItemType", "'BinaryMeta'").build();
        String result = (String)ContentClientProvider.getInstance().getContentClient().getEntity("Edm.String", clientQuery);
        if (StringUtils.isNotEmpty((String[])new String[]{result})) {
            BinaryMeta binaryMeta = BinaryMetaSerializer.fromJson((String)result, (ContentClientDataLoader)new ODataClientDataLoader());
            LOG.debug("Retrieved BinaryMeta instance: {}", (Object)binaryMeta);
            return binaryMeta;
        }
        LOG.debug("Could not find Binary metadata by url: {}", (Object)urlPath);
        return null;
    }
}

