/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.api.dynamic;

import com.sdl.web.api.dynamic.PageContentAssembler;
import com.sdl.web.content.client.impl.ContentClientProvider;
import com.sdl.web.content.client.impl.ODataV2ClientQuery;
import com.sdl.web.content.client.odata.v2.edm.PageContent;
import com.tridion.util.CMURI;
import java.text.ParseException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageContentAssemblerImpl
implements PageContentAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(PageContentAssemblerImpl.class);

    public String getContent(String pageURI) {
        return this.getContent(pageURI, null);
    }

    public String getContent(String pageURI, Map<String, String> variables) {
        try {
            CMURI pURI = new CMURI(pageURI);
            int pageId = pURI.getItemId();
            int pubId = pURI.getPublicationId();
            return this.getContent(pubId, pageId, variables);
        }
        catch (ParseException e) {
            LOG.error("PagePresentationAssembler:getContent(String, String) got invalid uri's as parameter, returning \"\"");
            return "";
        }
    }

    public String getContent(int publicationId, int pageId) {
        return this.getContent(publicationId, pageId, null);
    }

    public String getContent(int publicationId, int pageId, Map<String, String> variables) {
        PageContent content = (PageContent)ContentClientProvider.getInstance().getContentClient().getEntity(PageContent.class.getName(), new ODataV2ClientQuery.Builder().withEntityType(PageContent.class).withEntityParameterMap("PageId", "" + pageId).withEntityParameterMap("PublicationId", "" + publicationId).addQueryParameters(variables).build());
        if (content != null) {
            return content.getContent();
        }
        return "";
    }
}

