/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.api.dynamic;

import com.sdl.web.api.dynamic.WebTaxonomyAssembler;
import com.sdl.web.api.dynamic.formatter.WebTaxonomyFormatter;
import com.sdl.web.api.dynamic.formatters.TaxonomyHierarchyFormatter;
import com.sdl.web.api.dynamic.taxonomies.WebTaxonomyFactory;
import com.sdl.web.api.dynamic.taxonomies.filters.CompositeFilter;
import com.sdl.web.api.dynamic.taxonomies.filters.DepthFilter;
import com.sdl.web.api.dynamic.taxonomies.filters.WebTaxonomyFilter;
import com.sdl.web.api.taxonomies.WebTaxonomyFactoryImpl;
import com.tridion.taxonomies.Keyword;
import com.tridion.util.ArrayUtils;
import com.tridion.util.StringUtils;
import java.util.Arrays;
import java.util.List;

public class WebTaxonomyAssemblerImpl
implements WebTaxonomyAssembler {
    private final WebTaxonomyFilter taxonomyFilter;
    private final WebTaxonomyFormatter taxonomyFormatter;
    private final WebTaxonomyFactory taxonomyFactory;
    private static final String UL_TAG_START = "<ul>";
    private static final String UL_TAG_END = "</ul>";
    private static final String LI_TAG_START = "<li>";
    private static final String LI_TAG_END = "</li>";

    public WebTaxonomyAssemblerImpl() {
        this(null, null, null);
    }

    public WebTaxonomyAssemblerImpl(WebTaxonomyFilter taxonomyFilter, WebTaxonomyFormatter taxonomyFormatter, WebTaxonomyFactory taxonomyFactory) {
        this.taxonomyFilter = taxonomyFilter == null ? new CompositeFilter() : taxonomyFilter;
        this.taxonomyFormatter = taxonomyFormatter == null ? new TaxonomyHierarchyFormatter(true) : taxonomyFormatter;
        this.taxonomyFactory = taxonomyFactory == null ? new WebTaxonomyFactoryImpl() : taxonomyFactory;
    }

    public StringBuffer assembleTaxonomy(String taxonomyURI, String contextKeyword, boolean showRoot, boolean showEmptyKeywords, boolean showDescription, String pageRedirect, String keywordParameterName) {
        return this.assembleTaxonomy(taxonomyURI, null, null, contextKeyword, showRoot, showEmptyKeywords, showDescription, pageRedirect, keywordParameterName);
    }

    public StringBuffer assembleTaxonomy(String taxonomyURI, String[] expandKeywords, Keyword[] selectedKeywords, String contextKeyword, boolean showRoot, boolean showEmptyKeywords, boolean showDescription, String pageRedirect, String keywordParameterName) {
        if (!StringUtils.isEmpty((String)taxonomyURI)) {
            Keyword rootElement = this.taxonomyFactory.getTaxonomyKeywords(taxonomyURI, this.taxonomyFilter, contextKeyword, selectedKeywords, this.taxonomyFormatter);
            if (rootElement != null) {
                if (ArrayUtils.isNotEmpty((Object[])expandKeywords)) {
                    this.processSelectedElements(rootElement, taxonomyURI, expandKeywords, selectedKeywords);
                }
                StringBuffer stringOutput = new StringBuffer();
                if (showRoot) {
                    stringOutput.append(UL_TAG_START);
                }
                this.writeTaxonomy(stringOutput, rootElement, taxonomyURI, selectedKeywords, showRoot, showEmptyKeywords, showDescription, pageRedirect, keywordParameterName);
                if (showRoot) {
                    stringOutput.append(UL_TAG_END);
                }
                return stringOutput;
            }
            return null;
        }
        return null;
    }

    private void processSelectedElements(Keyword rootElement, String taxonomyURI, String[] expandKeywords, Keyword[] selectedKeywords) {
        DepthFilter childrenFilter = new DepthFilter(1, 1);
        for (String selectedURI : expandKeywords) {
            Keyword selectedElement = this.checkElementPresent(selectedURI, rootElement);
            if (selectedElement == null || !selectedElement.hasKeywordChildren() || selectedElement.getKeywordChildren().size() != 0) continue;
            Keyword parentElement = this.taxonomyFactory.getTaxonomyKeywords(taxonomyURI, (WebTaxonomyFilter)childrenFilter, selectedElement.getKeywordURI(), selectedKeywords, (WebTaxonomyFormatter)new TaxonomyHierarchyFormatter(true));
            for (Keyword childElement : parentElement.getKeywordChildren()) {
                childElement.setParentKeyword(selectedElement);
            }
        }
    }

    private Keyword checkElementPresent(String taxonomyElementURI, Keyword currentElement) {
        if (currentElement.getKeywordURI().equals(taxonomyElementURI)) {
            return currentElement;
        }
        for (Keyword child : currentElement.getKeywordChildren()) {
            Keyword result = this.checkElementPresent(taxonomyElementURI, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void writeTaxonomy(StringBuffer stringOutput, Keyword taxonomyElement, String taxonomyURI, Keyword[] selectedKeywords, boolean showRoot, boolean showEmptyKeywords, boolean showDescription, String pageRedirect, String keywordParameterName) {
        List elementChildren;
        StringBuilder endFacet = new StringBuilder("");
        if ((taxonomyElement.getParentKeyword() != null || taxonomyElement.getParentKeyword() == null && showRoot) && (showEmptyKeywords || !showEmptyKeywords && taxonomyElement.getReferencedContentCount() > 0)) {
            stringOutput.append(LI_TAG_START);
            stringOutput.append(this.getFacetAsHTML(taxonomyElement, taxonomyURI, selectedKeywords, showDescription, pageRedirect, keywordParameterName));
            endFacet.append(LI_TAG_END);
        }
        if ((elementChildren = taxonomyElement.getKeywordChildren()).size() > 0) {
            stringOutput.append(UL_TAG_START);
            for (Keyword taxonomyChild : elementChildren) {
                this.writeTaxonomy(stringOutput, taxonomyChild, taxonomyURI, selectedKeywords, showRoot, showEmptyKeywords, showDescription, pageRedirect, keywordParameterName);
            }
            stringOutput.append(UL_TAG_END);
        }
        stringOutput.append((CharSequence)endFacet);
    }

    private String getFacetAsHTML(Keyword facet, String taxonomyURI, Keyword[] selectedKeywords, boolean showDescription, String pageRedirect, String keywordParameterName) {
        String displayName = showDescription && StringUtils.isNotEmpty((String[])new String[]{facet.getKeywordDescription()}) ? facet.getKeywordDescription() : facet.getKeywordName();
        StringBuilder stringOutput = new StringBuilder();
        if (!this.isSelectedFacet(facet.getKeywordURI(), facet.getTaxonomyURI(), selectedKeywords)) {
            stringOutput.append("<a anchor=\"");
            stringOutput.append(facet.getKeywordURI());
            stringOutput.append("\" taxonomyURI=\"");
            stringOutput.append(taxonomyURI);
            stringOutput.append("\" elementURI=\"");
            stringOutput.append(facet.getKeywordURI());
            stringOutput.append("\"");
            if (facet.hasKeywordChildren()) {
                if (facet.getKeywordChildren().size() == 0) {
                    stringOutput.append(" class=\"expandable\"");
                } else {
                    stringOutput.append(" class=\"collapsable\"");
                }
            } else {
                stringOutput.append(" class=\"notexpandable\"");
            }
            if (facet.isKeywordNavigable()) {
                stringOutput.append(" href=\"");
                stringOutput.append(pageRedirect);
                stringOutput.append("?");
                stringOutput.append(keywordParameterName);
                stringOutput.append("=");
                stringOutput.append(facet.getKeywordURI());
                stringOutput.append("&taxonomyURI=");
                stringOutput.append(facet.getTaxonomyURI());
                stringOutput.append("\"");
            }
            stringOutput.append(">");
            stringOutput.append(displayName);
            stringOutput.append(" (");
            stringOutput.append(facet.getReferencedContentCount());
            stringOutput.append(")");
            stringOutput.append("</a>");
        } else {
            stringOutput.append("<b");
            if (facet.hasKeywordChildren()) {
                if (facet.getKeywordChildren().size() == 0) {
                    stringOutput.append(" class=\"expandable\"");
                } else {
                    stringOutput.append(" class=\"collapsable\"");
                }
            } else {
                stringOutput.append(" class=\"notexpandable\"");
            }
            stringOutput.append(">");
            stringOutput.append(displayName);
            stringOutput.append(" (");
            stringOutput.append(facet.getReferencedContentCount());
            stringOutput.append(")");
            stringOutput.append("</b>");
        }
        return stringOutput.toString();
    }

    private boolean isSelectedFacet(String facetURI, String taxonomyURI, Keyword[] selectedKeywords) {
        return ArrayUtils.isNotEmpty((Object[])selectedKeywords) && Arrays.stream(selectedKeywords).anyMatch(selectedKeyword -> selectedKeyword.getKeywordURI().equals(facetURI) && selectedKeyword.getTaxonomyURI().equals(taxonomyURI));
    }
}

