/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.retry;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryBlock<P, E extends Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRetryBlock.class);
    private static final int MAX_RETRY_COUNT_DEFAULT_VALUE = 5;
    private static final int ATTEMPT_DELAY_FACTOR_DEFAULT_VALUE = 100;
    private final Supplier<P> propertyProvider;
    private final int maxRetryCount;
    private final int attemptDelayFactor;
    private int attempt = 0;

    public AbstractRetryBlock(Supplier<P> propertyProvider, int maxRetryCount, int attemptDelayFactor) {
        this.propertyProvider = propertyProvider;
        this.maxRetryCount = maxRetryCount;
        this.attemptDelayFactor = attemptDelayFactor;
    }

    public AbstractRetryBlock(Supplier<P> propertyProvider) {
        this.propertyProvider = propertyProvider;
        this.maxRetryCount = 5;
        this.attemptDelayFactor = 100;
    }

    protected void retryIfNecessary(E e, String msg) throws E {
        if (this.attempt >= this.maxRetryCount) {
            LOG.debug("Retry limit exceeded.", e);
            throw e;
        }
        this.sleep();
        LOG.debug(msg);
    }

    private void sleep() {
        try {
            Thread.sleep((long)Math.pow(2.0, this.attempt) * (long)this.attemptDelayFactor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.debug("Retry process was interrupted. Exiting.", (Throwable)e);
        }
    }

    protected Supplier<P> getPropertyProvider() {
        return this.propertyProvider;
    }

    protected int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    protected int getAttempt() {
        return this.attempt;
    }

    protected void incrementAttempt() {
        ++this.attempt;
    }
}

