/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.retry;

import com.sdl.delivery.retry.AbstractRetryBlock;
import com.sdl.delivery.retry.ThrowableConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerRetryBlock<P, E extends Throwable>
extends AbstractRetryBlock<P, E> {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerRetryBlock.class);
    private ThrowableConsumer<P, E> consumer;

    public ConsumerRetryBlock(ThrowableConsumer<P, E> consumer, Supplier<P> propertyProvider) {
        super(propertyProvider);
        this.consumer = consumer;
    }

    public ConsumerRetryBlock(ThrowableConsumer<P, E> consumer, Supplier<P> propertyProvider, int maxRetryCount, int attemptDelayFactor) {
        super(propertyProvider, maxRetryCount, attemptDelayFactor);
        this.consumer = consumer;
    }

    public void execute() throws E {
        while (this.getAttempt() < this.getMaxRetryCount()) {
            this.incrementAttempt();
            try {
                Object requestProperty = this.getPropertyProvider().get();
                LOG.debug("Property for ConsumerRetryBlock to apply: {}", requestProperty);
                this.consumer.accept(requestProperty);
                return;
            }
            catch (Throwable e) {
                this.retryIfNecessary(e, String.format("%s. Will retry. Attempt #%d.", e.getMessage(), this.getAttempt()));
            }
        }
        throw new RuntimeException("Retry limit exceeded.");
    }
}

