/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.retry;

import com.sdl.delivery.retry.AbstractRetryBlock;
import com.sdl.delivery.retry.ThrowableFunction;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRetryBlock<P, R, E extends Throwable>
extends AbstractRetryBlock<P, E> {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionRetryBlock.class);
    private final ThrowableFunction<P, R, E> function;

    public FunctionRetryBlock(ThrowableFunction<P, R, E> function, Supplier<P> propertyProvider) {
        super(propertyProvider);
        this.function = function;
    }

    public FunctionRetryBlock(ThrowableFunction<P, R, E> function, Supplier<P> propertyProvider, int maxRetryCount, int attemptDelayFactor) {
        super(propertyProvider, maxRetryCount, attemptDelayFactor);
        this.function = function;
    }

    public R execute() throws E {
        while (this.getAttempt() < this.getMaxRetryCount()) {
            this.incrementAttempt();
            try {
                Object requestProperty = this.getPropertyProvider().get();
                LOG.debug("Property for FunctionRetryBlock to apply: {}", requestProperty);
                return this.function.apply(requestProperty);
            }
            catch (Throwable e) {
                this.retryIfNecessary(e, String.format("%s. Will retry. Attempt #%d.", e.getMessage(), this.getAttempt()));
            }
        }
        throw new RuntimeException("Retry limit exceeded.");
    }
}

