/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum LogLevel {
    TRACE("trace"),
    DEBUG("debug"),
    INFO("info"),
    WARN(new String[]{"warn", "warning"}),
    ERROR("error"),
    FATAL(new String[]{"fatal", "severe"});

    private Set<String> allowedNames = new HashSet<String>();

    private LogLevel(String levelName) {
        this.allowedNames.add(levelName);
    }

    private LogLevel(String[] levelNames) {
        this.allowedNames.addAll(Arrays.asList(levelNames));
    }

    public static LogLevel valueOfName(String level) {
        if (level == null || level.isEmpty()) {
            return DEBUG;
        }
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.allowedNames.contains(level)) continue;
            return logLevel;
        }
        return DEBUG;
    }
}

