/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security;

import com.sdl.delivery.security.EventType;
import com.sdl.delivery.security.LogLevel;
import com.sdl.delivery.security.LoggerFactory;
import org.slf4j.Logger;

public class RequestArgumentsSanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(RequestArgumentsSanitizer.class);

    private RequestArgumentsSanitizer() {
    }

    public static Object[] getSanitizedCopy(Object ... argArray) {
        if (argArray == null || argArray.length == 0) {
            throw new IllegalStateException("Arguments are not provided or empty");
        }
        int length = argArray.length;
        int indexOfException = -1;
        Object lastElement = argArray[length - 1];
        if (lastElement != null && Throwable.class.isAssignableFrom(lastElement.getClass())) {
            indexOfException = length - 1;
        }
        int index = 0;
        Object[] trimmed = new Object[length];
        for (Object arg : argArray) {
            trimmed[index++] = RequestArgumentsSanitizer.sanitize(arg);
            if (indexOfException <= 0 || indexOfException != index) continue;
            trimmed[length - 1] = lastElement;
            break;
        }
        return trimmed;
    }

    public static Object sanitize(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (Throwable.class.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        String toString = arg.toString();
        return toString.replaceAll("\\n|\\r", "\u2b0e").replaceAll("%0[aAdD]", "\u2935");
    }

    public static void sanitizeTrace(Logger log, EventType eventTypeArg, String message, Object ... args) {
        RequestArgumentsSanitizer.checkArgs(log, eventTypeArg, message);
        log.trace(message, RequestArgumentsSanitizer.getSanitizedCopy(args));
    }

    public static void sanitizeDebug(Logger log, EventType eventTypeArg, String message, Object ... args) {
        RequestArgumentsSanitizer.checkArgs(log, eventTypeArg, message);
        log.debug(message, RequestArgumentsSanitizer.getSanitizedCopy(args));
    }

    public static void sanitizeInfo(Logger log, EventType eventTypeArg, String message, Object ... args) {
        RequestArgumentsSanitizer.checkArgs(log, eventTypeArg, message);
        log.info(message, RequestArgumentsSanitizer.getSanitizedCopy(args));
    }

    public static void sanitizeWarn(Logger log, EventType eventTypeArg, String message, Object ... args) {
        RequestArgumentsSanitizer.checkArgs(log, eventTypeArg, message);
        log.warn(message, RequestArgumentsSanitizer.getSanitizedCopy(args));
    }

    public static void sanitizeError(Logger log, EventType eventTypeArg, String message, Object ... args) {
        RequestArgumentsSanitizer.checkArgs(log, eventTypeArg, message);
        log.error(message, RequestArgumentsSanitizer.getSanitizedCopy(args));
    }

    private static EventType checkArgs(Logger log, EventType eventType, String message) {
        if (log == null) {
            IllegalArgumentException noLogger = new IllegalArgumentException("Logger is not provided");
            LOG.error("Logger is not provided for logging '{}'", (Object)message, (Object)noLogger);
            throw noLogger;
        }
        if (eventType == null) {
            return EventType.EVENT_SUCCESS;
        }
        return eventType;
    }

    public static void sanitize(Logger log, String logLevelArg, EventType eventType, String message, Object ... args) {
        LogLevel logLevel = LogLevel.valueOfName(logLevelArg);
        if (logLevel == LogLevel.TRACE) {
            RequestArgumentsSanitizer.sanitizeTrace(log, eventType, message, args);
        } else if (logLevel == LogLevel.DEBUG) {
            RequestArgumentsSanitizer.sanitizeDebug(log, eventType, message, args);
        } else if (logLevel == LogLevel.INFO) {
            RequestArgumentsSanitizer.sanitizeInfo(log, eventType, message, args);
        } else if (logLevel == LogLevel.WARN) {
            RequestArgumentsSanitizer.sanitizeWarn(log, eventType, message, args);
        } else {
            RequestArgumentsSanitizer.sanitizeError(log, eventType, message, args);
        }
    }

    public static void sanitize(Logger log, String logLevel, String message, Object ... args) {
        RequestArgumentsSanitizer.sanitize(log, logLevel, EventType.EVENT_SUCCESS, message, args);
    }
}

