/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.uri.processor;

import com.sdl.delivery.security.uri.processor.IsInRestrictionLists;
import com.sdl.delivery.security.uri.processor.UriRestrictions;
import java.net.URI;

public class SecureUriCreatorAndVerifier {
    private static final String ADF_CLAIM_PREFIX = "taf:";

    public URI createUri(String possibleUrl) {
        UriRestrictions uriRestrictions = UriRestrictions.getInstance();
        if (uriRestrictions == null || possibleUrl.startsWith(ADF_CLAIM_PREFIX)) {
            return URI.create(possibleUrl);
        }
        IsInRestrictionLists result = uriRestrictions.verifyUri(possibleUrl);
        switch (result) {
            case INVALID: {
                throw new IllegalArgumentException("Given URL '" + possibleUrl + "' is illegal");
            }
            case PROHIBITED: {
                throw new IllegalArgumentException("Given URL '" + possibleUrl + "' is prohibited");
            }
            case NONE: {
                if (uriRestrictions.isUnknownProcessingEnabled()) break;
                throw new IllegalArgumentException("Given URL '" + possibleUrl + "' does not match any configured pattern");
            }
            case ALLOWED: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown option: " + result);
            }
        }
        return URI.create(possibleUrl);
    }
}

