/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.uri.processor;

import com.sdl.delivery.security.uri.processor.IsInRestrictionLists;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriRestrictions {
    private static final Logger LOG = LoggerFactory.getLogger(UriRestrictions.class);
    private static volatile UriRestrictions instance = null;
    private final Set<Pattern> allowedPatterns = new HashSet<Pattern>();
    private final Set<Pattern> prohibitedPatterns = new HashSet<Pattern>();
    private boolean unknownProcessingEnabled = false;

    public void addAllowed(String pattern) {
        Pattern compiled = this.checkPattern(pattern);
        this.allowedPatterns.add(compiled);
    }

    public void addProhibited(String pattern) {
        Pattern compiled = this.checkPattern(pattern);
        this.prohibitedPatterns.add(compiled);
    }

    private Pattern checkPattern(String patternArg) {
        if (patternArg == null || patternArg.isEmpty()) {
            throw new IllegalArgumentException("No pattern provided");
        }
        String pattern = patternArg;
        if (patternArg.endsWith("$")) {
            pattern = patternArg.substring(0, patternArg.length() - 1);
        }
        try {
            if (pattern.endsWith("/") && !pattern.endsWith("://")) {
                return Pattern.compile(pattern.substring(0, pattern.length() - 1));
            }
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("Invalid pattern '" + pattern + "' provided", ex);
        }
    }

    public IsInRestrictionLists verifyUri(String possibleUriArg) {
        Optional<Pattern> isInList;
        if (possibleUriArg == null) {
            return IsInRestrictionLists.INVALID;
        }
        if ((possibleUriArg = possibleUriArg.trim()).endsWith("/") && !possibleUriArg.endsWith("://")) {
            possibleUriArg = possibleUriArg.substring(0, possibleUriArg.length() - 1);
        }
        if (possibleUriArg.isEmpty()) {
            return IsInRestrictionLists.INVALID;
        }
        String possibleUri = possibleUriArg;
        if (this.allowedPatterns.isEmpty() && this.prohibitedPatterns.isEmpty()) {
            return IsInRestrictionLists.NONE;
        }
        if (!this.prohibitedPatterns.isEmpty() && (isInList = this.prohibitedPatterns.stream().filter(pattern -> pattern.matcher(possibleUri).matches()).findAny()).isPresent()) {
            LOG.warn("Provided URI '{}' is disabled by pattern '{}'", (Object)possibleUri, (Object)isInList.get().pattern());
            return IsInRestrictionLists.PROHIBITED;
        }
        if (!this.allowedPatterns.isEmpty() && (isInList = this.allowedPatterns.stream().filter(pattern -> pattern.matcher(possibleUri).matches()).findAny()).isPresent()) {
            LOG.debug("Provided URI '{}' is allowed by pattern '{}'", (Object)possibleUri, (Object)isInList.get().pattern());
            return IsInRestrictionLists.ALLOWED;
        }
        return IsInRestrictionLists.NONE;
    }

    public static void setInstance(UriRestrictions instance) {
        UriRestrictions.instance = instance;
    }

    public static UriRestrictions getInstance() {
        return instance;
    }

    public void setProcessingEnabled() {
        this.unknownProcessingEnabled = true;
    }

    public boolean isUnknownProcessingEnabled() {
        return this.unknownProcessingEnabled;
    }

    Set<Pattern> getAllowedPatterns() {
        return Collections.unmodifiableSet(this.allowedPatterns);
    }

    Set<Pattern> getProhibitedPatterns() {
        return Collections.unmodifiableSet(this.prohibitedPatterns);
    }
}

