/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml;

import com.sdl.delivery.security.xml.XmlEqualsResult;
import com.sdl.delivery.security.xml.XmlRestriction;
import com.sdl.delivery.security.xml.helper.XmlEqualityChecker;
import com.sdl.delivery.security.xml.processor.SecureDocumentBuilderFactoryProcessor;
import com.sdl.delivery.security.xml.processor.SecureTransformerFactoryProcessor;
import com.sdl.delivery.security.xml.processor.SecureXmlInputFactoryProcessor;
import com.sdl.delivery.security.xml.processor.SecureXmlValidatorProcessor;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class SecureXmlProcessingUtils {
    private static final SecureTransformerFactoryProcessor TRANSFORMER_FACTORY_PROCESSOR = new SecureTransformerFactoryProcessor();
    private static final SecureXmlValidatorProcessor VALIDATOR_PROCESSOR = new SecureXmlValidatorProcessor();
    private static final SecureDocumentBuilderFactoryProcessor BUILDER_FACTORY_PROCESSOR = new SecureDocumentBuilderFactoryProcessor();
    private static final XmlEqualityChecker XML_EQUALITY_CHECKER = new XmlEqualityChecker();
    private static final SecureXmlInputFactoryProcessor SECURE_XML_INPUT_FACTORY = new SecureXmlInputFactoryProcessor();

    private SecureXmlProcessingUtils() {
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory(XmlRestriction ... restrictions) {
        return BUILDER_FACTORY_PROCESSOR.createFactory(restrictions);
    }

    public static TransformerFactory createTransformerFactory(XmlRestriction ... restrictions) {
        return TRANSFORMER_FACTORY_PROCESSOR.createTransformerFactory(restrictions);
    }

    public static SAXTransformerFactory createSaxTransformerFactory(XmlRestriction ... restrictions) {
        return TRANSFORMER_FACTORY_PROCESSOR.createSaxTransformerFactory(restrictions);
    }

    public static XMLInputFactory createXmlInputFactory(XmlRestriction ... restrictions) {
        return SECURE_XML_INPUT_FACTORY.createSecureInputFactory(restrictions);
    }

    public static Transformer createTransformer(String stylesheet, Optional<Map<String, Object>> transformParameters, XmlRestriction ... restrictions) throws TransformerConfigurationException {
        return TRANSFORMER_FACTORY_PROCESSOR.createTransformer(stylesheet, transformParameters, restrictions);
    }

    public static Transformer createTransformer(XmlRestriction ... restrictions) throws TransformerConfigurationException {
        return TRANSFORMER_FACTORY_PROCESSOR.createTransformer(null, Optional.empty(), restrictions);
    }

    public static Validator createValidator(InputStream xsdStream, XmlRestriction ... restrictions) throws SAXException {
        return VALIDATOR_PROCESSOR.createValidator(xsdStream, restrictions);
    }

    public static Validator createValidator(String xsdContent, XmlRestriction ... restrictions) throws SAXException {
        return VALIDATOR_PROCESSOR.createValidator(xsdContent, restrictions);
    }

    public static XmlEqualsResult xmlEquals(String expectedXml, String actualXml) throws Exception {
        return XML_EQUALITY_CHECKER.xmlEquals(expectedXml, actualXml);
    }
}

