/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml;

import java.util.regex.Pattern;

public class XmlEqualsResult {
    private static final Pattern WHITESPACES = Pattern.compile("\\s+|\\r|\\n|\\t");
    private final boolean equals;
    private final String expected;
    private final String actual;

    public XmlEqualsResult(String expected, String actual) {
        this.expected = this.strip(expected);
        this.actual = this.strip(actual);
        this.equals = this.expected.equals(this.actual);
    }

    public boolean isEquals() {
        return this.equals;
    }

    public String getExpected() {
        return this.expected;
    }

    public String getActual() {
        return this.actual;
    }

    String strip(String transform) {
        return WHITESPACES.matcher(transform.replaceAll(">\\s?</", ">\n</")).replaceAll("\n");
    }
}

