/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.delivery.security.xml;

import com.sdl.delivery.security.xml.ResourceType;

public enum XmlRestriction {
    ALLOW_EXTERNAL_DTD_NONE(ResourceType.DTD, ""),
    ALLOW_EXTERNAL_DTD_FILE(ResourceType.DTD, "file"),
    ALLOW_EXTERNAL_DTD_JAR(ResourceType.DTD, "jar"),
    ALLOW_EXTERNAL_DTD_FILE_IN_JAR(ResourceType.DTD, "jar:file"),
    ALLOW_EXTERNAL_DTD_HTTP(ResourceType.DTD, "http"),
    ALLOW_EXTERNAL_DTD_HTTPS(ResourceType.DTD, "https"),
    ALLOW_EXTERNAL_DTD_FTP(ResourceType.DTD, "ftp"),
    ALLOW_EXTERNAL_DTD_FTPS(ResourceType.DTD, "ftps"),
    ALLOW_EXTERNAL_DTD_SFTP(ResourceType.DTD, "sftp"),
    ALLOW_EXTERNAL_DTD_ALL(ResourceType.DTD, "all"),
    ALLOW_EXTERNAL_SCHEMA_NONE(ResourceType.SCHEMA, ""),
    ALLOW_EXTERNAL_SCHEMA_FILE(ResourceType.SCHEMA, "file"),
    ALLOW_EXTERNAL_SCHEMA_JAR(ResourceType.SCHEMA, "jar"),
    ALLOW_EXTERNAL_SCHEMA_FILE_IN_JAR(ResourceType.SCHEMA, "jar:file"),
    ALLOW_EXTERNAL_SCHEMA_HTTP(ResourceType.SCHEMA, "http"),
    ALLOW_EXTERNAL_SCHEMA_HTTPS(ResourceType.SCHEMA, "https"),
    ALLOW_EXTERNAL_SCHEMA_FTP(ResourceType.SCHEMA, "ftp"),
    ALLOW_EXTERNAL_SCHEMA_FTPS(ResourceType.SCHEMA, "ftps"),
    ALLOW_EXTERNAL_SCHEMA_SFTP(ResourceType.SCHEMA, "sftp"),
    ALLOW_EXTERNAL_SCHEMA_ALL(ResourceType.SCHEMA, "all"),
    ALLOW_EXTERNAL_STYLESHEET_NONE(ResourceType.STYLESHEET, ""),
    ALLOW_EXTERNAL_STYLESHEET_FILE(ResourceType.STYLESHEET, "file"),
    ALLOW_EXTERNAL_STYLESHEET_JAR(ResourceType.STYLESHEET, "jar"),
    ALLOW_EXTERNAL_STYLESHEET_FILE_IN_JAR(ResourceType.STYLESHEET, "jar:file"),
    ALLOW_EXTERNAL_STYLESHEET_HTTP(ResourceType.STYLESHEET, "http"),
    ALLOW_EXTERNAL_STYLESHEET_HTTPS(ResourceType.STYLESHEET, "https"),
    ALLOW_EXTERNAL_STYLESHEET_FTP(ResourceType.STYLESHEET, "ftp"),
    ALLOW_EXTERNAL_STYLESHEET_FTPS(ResourceType.STYLESHEET, "ftps"),
    ALLOW_EXTERNAL_STYLESHEET_SFTP(ResourceType.STYLESHEET, "sftp"),
    ALLOW_EXTERNAL_STYLESHEET_ALL(ResourceType.STYLESHEET, "all");

    private static final XmlRestriction[] XML_RESTRICTIONS_REMOTE_FILES;
    private static final XmlRestriction[] XML_RESTRICTIONS_LOCAL_FILES;
    private final ResourceType resourceType;
    private final String protocol;

    private XmlRestriction(ResourceType resourceType, String protocol) {
        this.resourceType = resourceType;
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public static XmlRestriction[] makeForLocalFiles() {
        return XML_RESTRICTIONS_LOCAL_FILES;
    }

    public static XmlRestriction[] makeForRemoteFiles() {
        return XML_RESTRICTIONS_REMOTE_FILES;
    }

    static {
        XML_RESTRICTIONS_REMOTE_FILES = new XmlRestriction[]{ALLOW_EXTERNAL_DTD_HTTP, ALLOW_EXTERNAL_DTD_HTTPS, ALLOW_EXTERNAL_DTD_FTP, ALLOW_EXTERNAL_DTD_FTPS, ALLOW_EXTERNAL_DTD_SFTP, ALLOW_EXTERNAL_SCHEMA_HTTP, ALLOW_EXTERNAL_SCHEMA_HTTPS, ALLOW_EXTERNAL_SCHEMA_FTP, ALLOW_EXTERNAL_SCHEMA_FTPS, ALLOW_EXTERNAL_SCHEMA_SFTP, ALLOW_EXTERNAL_STYLESHEET_HTTP, ALLOW_EXTERNAL_STYLESHEET_HTTPS, ALLOW_EXTERNAL_STYLESHEET_FTP, ALLOW_EXTERNAL_STYLESHEET_FTPS, ALLOW_EXTERNAL_STYLESHEET_SFTP};
        XML_RESTRICTIONS_LOCAL_FILES = new XmlRestriction[]{ALLOW_EXTERNAL_DTD_FILE, ALLOW_EXTERNAL_DTD_JAR, ALLOW_EXTERNAL_DTD_FILE_IN_JAR, ALLOW_EXTERNAL_SCHEMA_FILE, ALLOW_EXTERNAL_SCHEMA_JAR, ALLOW_EXTERNAL_SCHEMA_FILE_IN_JAR, ALLOW_EXTERNAL_STYLESHEET_FILE, ALLOW_EXTERNAL_STYLESHEET_JAR, ALLOW_EXTERNAL_STYLESHEET_FILE_IN_JAR};
    }
}

